---
title: Introduction to the Learn Basic CSS by Building a Cafe Menu
block: learn-basic-css-by-building-a-cafe-menu
superBlock: 2022/responsive-web-design
---

## Introduction to the Learn Basic CSS by Building a Cafe Menu

Cascading Style Sheets (CSS) tell the browser how to display the text and other content that you write in HTML.

Note that CSS is case-sensitive so be careful with your capitalization.

CSS has been adopted by all major browsers and allows you to control:

- color
- fonts
- positioning
- spacing
- sizing
- decorations
- transitions

There are three main ways to apply CSS styling. You can apply inline styles directly to HTML elements with the `style` attribute. Alternatively, you can place CSS rules within `style` tags in an HTML document. Finally, you can write CSS rules in an external style sheet, then reference that file in the HTML document. Even though the first two options have their use cases, most developers prefer external style sheets because they keep the styles separate from the HTML elements. This improves the readability and reusability of your code.

The idea behind CSS is that you can use a selector to target an HTML element in the DOM (Document Object Model) and then apply a variety of attributes to that element to change the way it is displayed on the page.

In this project, you'll see how adding CSS styles to the elements of your application can change it from simple text to something more.
