---
title: Introduction to the Managing Packages with npm Challenges
block: managing-packages-with-npm
superBlock: back-end-development-and-apis
---

## Introduction to the Managing Packages with npm Challenges

The Node Package Manager (npm) is a command-line tool used by developers to share and control modules (or packages) of JavaScript code written for use with Node.js.<br><br>When starting a new project, npm generates a <code>package.json</code> file. This file lists the package dependencies for your project. Since npm packages are regularly updated, the <code>package.json</code> file allows you to set specific version numbers for each dependency. This ensures that updates to a package don't break your project.

npm saves packages in a folder named <code>node_modules</code>. These packages can be installed in two ways:

1. globally in a root <code>node_modules</code> folder, accessible by all projects.
2. locally within a project's own <code>node_modules</code> folder, accessible only to that project.

Most developers prefer to install packages local to each project to create a separation between the dependencies of different projects.

Working on these challenges involves writing code on Replit in our starter project.

- Start by importing the project on Replit.
- Next, you will see a <code>.replit</code> window.
- Select <code>Use run command</code> and click the <code>Done</code> button.
- Complete each challenge and copy the public Replit URL (to the homepage of your app) into the challenge screen to test it!

Optionally, you may write your project on another platform, but it must be publicly visible for our testing.

Start this project by cloning <a href='https://github.com/freeCodeCamp/boilerplate-npm/'>this repository</a> on GitHub!
