---
title: Responsive Web Design
superBlock: responsive-web-design
certification: responsive-web-design
---

## Introduction to Responsive Web Design

Welcome to Responsive Web Design!

Let's first take a look at what is in the scope of Responsive Web Design (and what is not).

The Web part of Responsive Web Design means that the content you are creating is designed to be delivered over the web to users' browsers. To do this, you will need to learn the language that browsers use to describe web pages: HTML (Hypertext Markup Language) for content, and CSS (Cascading Style Sheets) for design.

That brings us to design. Web Design focuses on how websites should look and behave to the end user. There are plenty of additional aspects to websites, including how to host a website so people can access it, how to protect your websites and store your users' data, and the ethos behind what should go on a website in the first place. These are somewhat harder to teach, but do require a good understanding of the capabilities of the web in modern contexts.

And what of the word Responsive? Well, that brings us to the idea of modern contexts. In today's world, websites are expected to be just as accessible on laptops, tablets and phones. If you compare your user experience on a document-editing program on a computer versus a document-editing program on a mobile, the features on mobile are likely to be far more constrained. This applies in some way to websites as well, but developers have found interesting ways to adapt to the mobile experience, not in the least by harnessing powerful features built for flexible (a.k.a responsive) web displays such as CSS `flexbox` and CSS `grid`.

Ready to learn about good design practices for the web? Let's get started!

[Begin Course](https://www.freecodecamp.org/learn/responsive-web-design/basic-html-and-html5/)
