---
title: Learn List Comprehension by Building a Case Converter Program
block: learn-list-comprehension-by-building-a-case-converter-program
superBlock: scientific-computing-with-python
---

## Learn List Comprehension by Building a Case Converter Program

List comprehension is a way to construct a new Python list from an iterable, such as lists, tuples, and strings, without using a for loop or the `.append()` list method. It provides a concise and readable way to create lists and can be used to apply an expression to each item in the iterable.

In this project, you'll write a program that takes a string formatted in Camel Case or Pascal Case and converts it into Snake Case. Camel Case and Pascal Case are naming conventions where each word in the identifier is capitalized, with Camel Case starting with a lowercase letter (e.g., `camelCase`) and Pascal Case starting with an uppercase letter (e.g., `PascalCase`). Snake Case, on the other hand, separates words with underscores and uses only lowercase letters (e.g., `snake_case`).

The project has two phases: first, you'll use a for loop to implement the program. Then you'll learn how to use list comprehension instead of a loop to achieve the same results. This will help you understand the efficiency and elegance that list comprehension can bring to your code.
