---
id: 68adce01c0e1144d0a902956
title: "Challenge 25: Vowel Repeater"
challengeType: 28
dashedName: challenge-25
---

# --description--

Given a string, return a new version of the string where each vowel is duplicated one more time than the previous vowel you encountered. For instance, the first vowel in the sentence should remain unchanged. The second vowel should appear twice in a row. The third vowel should appear three times in a row, and so on.

- The letters `a`, `e`, `i`, `o`, and `u`, in either uppercase or lowercase, are considered vowels.
- The original vowel should keeps its case.
- Repeated vowels should be lowercase.
- All non-vowel characters should keep their original case.

# --hints--

`repeatVowels("hello world")` should return `"helloo wooorld"`.

```js
assert.equal(repeatVowels("hello world"), "helloo wooorld");
```

`repeatVowels("freeCodeCamp")` should return `"freeeCooodeeeeCaaaaamp"`.

```js
assert.equal(repeatVowels("freeCodeCamp"), "freeeCooodeeeeCaaaaamp");
```

`repeatVowels("AEIOU")` should return `"AEeIiiOoooUuuuu"`.

```js
assert.equal(repeatVowels("AEIOU"), "AEeIiiOoooUuuuu");
```

`repeatVowels("I like eating ice cream in Iceland")` should return `"I liikeee eeeeaaaaatiiiiiing iiiiiiiceeeeeeee creeeeeeeeeaaaaaaaaaam iiiiiiiiiiin Iiiiiiiiiiiiceeeeeeeeeeeeelaaaaaaaaaaaaaand"`.

```js
assert.equal(repeatVowels("I like eating ice cream in Iceland"), "I liikeee eeeeaaaaatiiiiiing iiiiiiiceeeeeeee creeeeeeeeeaaaaaaaaaam iiiiiiiiiiin Iiiiiiiiiiiiceeeeeeeeeeeeelaaaaaaaaaaaaaand");
```

# --seed--

## --seed-contents--

```js
function repeatVowels(str) {

  return str;
}
```

# --solutions--

```js
function repeatVowels(str) {
  const vowels = "aeiouAEIOU";
  let count = 0;
  let result = "";

  for (let char of str) {
    result += char;
    if (vowels.includes(char)) {
      result += char.repeat(count).toLowerCase();
      count++;
    }
  }

  return result;
}
```
