---
id: 68adce01c0e1144d0a90295e
title: "Challenge 29: Acronym Builder"
challengeType: 28
dashedName: challenge-29
---

# --description--

Given a string containing one or more words, return an acronym of the words using the following constraints:

- The acronym should consist of the first letter of each word capitalized, unless otherwise noted.
- The acronym should ignore the first letter of these words unless they are the first word of the given string: `a`, `for`, `an`, `and`, `by`, and `of`.
- The acronym letters should be returned in the order they are given.
- The acronym should not contain any spaces.

# --hints--

`buildAcronym("Search Engine Optimization")` should return `"SEO"`.

```js
assert.equal(buildAcronym("Search Engine Optimization"), "SEO");
```

`buildAcronym("Frequently Asked Questions")` should return `"FAQ"`.

```js
assert.equal(buildAcronym("Frequently Asked Questions"), "FAQ");
```

`buildAcronym("National Aeronautics and Space Administration")` should return `"NASA"`.

```js
assert.equal(buildAcronym("National Aeronautics and Space Administration"), "NASA");
```

`buildAcronym("Federal Bureau of Investigation")` should return `"FBI"`.

```js
assert.equal(buildAcronym("Federal Bureau of Investigation"), "FBI");
```

`buildAcronym("For your information")` should return `"FYI"`.

```js
assert.equal(buildAcronym("Light Amplification by Stimulated Emission of Radiation"), "LASER");
```

`buildAcronym("By the way")` should return `"BTW"`.

```js
assert.equal(buildAcronym("By the way"), "BTW");
```

`buildAcronym("An unstoppable herd of waddling penguins overtakes the icy mountains and sings happily")` should return `"AUHWPOTIMSH"`.

```js
assert.equal(buildAcronym("An unstoppable herd of waddling penguins overtakes the icy mountains and sings happily"), "AUHWPOTIMSH");
```

# --seed--

## --seed-contents--

```js
function buildAcronym(str) {

  return str;
}
```

# --solutions--

```js
function buildAcronym(str) {
  const smallWords = ["a", "for", "an", "and", "by", "of"];
  const words = str.split(" ");
  let acronym = "";

  for (let i = 0; i < words.length; i++) {
    const word = words[i];
    const lowerWord = word.toLowerCase();

    if (i === 0 || !smallWords.includes(lowerWord)) {
      acronym += word[0].toUpperCase();
    }
  }

  return acronym;
}
```
