---
id: 68af0687ef34c76c28ffa54f
title: "Challenge 34: Missing Numbers"
challengeType: 28
dashedName: challenge-34
---

# --description--

Given an array of integers from 1 to `n`, inclusive, return an array of all the missing integers between 1 and `n` (where `n` is the largest number in the given array).

- The given array may be unsorted and may contain duplicates.
- The returned array should be in ascending order.
- If no integers are missing, return an empty array.

# --hints--

`findMissingNumbers([1, 3, 5])` should return `[2, 4]`.

```js
assert.deepEqual(findMissingNumbers([1, 3, 5]), [2, 4]);
```

`findMissingNumbers([1, 2, 3, 4, 5])` should return `[]`.

```js
assert.deepEqual(findMissingNumbers([1, 2, 3, 4, 5]), []);
```

`findMissingNumbers([1, 10])` should return `[2, 3, 4, 5, 6, 7, 8, 9]`.

```js
assert.deepEqual(findMissingNumbers([1, 10]), [2, 3, 4, 5, 6, 7, 8, 9]);
```

`findMissingNumbers([10, 1, 10, 1, 10, 1])` should return `[2, 3, 4, 5, 6, 7, 8, 9]`.

```js
assert.deepEqual(findMissingNumbers([10, 1, 10, 1, 10, 1]), [2, 3, 4, 5, 6, 7, 8, 9]);
```

`findMissingNumbers([3, 1, 4, 1, 5, 9])` should return `[2, 6, 7, 8]`.

```js
assert.deepEqual(findMissingNumbers([1, 2, 3, 4, 5]), []);
```

`findMissingNumbers([1, 2, 3, 4, 5, 7, 8, 9, 10, 12, 6, 8, 9, 3, 2, 10, 7, 4])` should return `[11]`.

```js
assert.deepEqual(findMissingNumbers([1, 2, 3, 4, 5, 7, 8, 9, 10, 12, 6, 8, 9, 3, 2, 10, 7, 4]), [11]);
```

# --seed--

## --seed-contents--

```js
function findMissingNumbers(arr) {

  return arr;
}
```

# --solutions--

```js
function findMissingNumbers(arr) {
  if (arr.length === 0) return [];
  
  const n = Math.max(...arr);
  const set = new Set(arr);
  const result = [];

  for (let i = 1; i <= n; i++) {
    if (!set.has(i)) {
      result.push(i);
    }
  }
  return result;
}
```
