---
id: 68b06e589bf2273243814775
title: "Challenge 38: Slug Generator"
challengeType: 28
dashedName: challenge-38
---

# --description--

Given a string, return a URL-friendly version of the string using the following constraints:

- All letters should be lowercase.
- All characters that are not letters, numbers, or spaces should be removed.
- All spaces should be replaced with the URL-encoded space code `%20`.
- Consecutive spaces should be replaced with a single `%20`.
- The returned string should not have leading or trailing `%20`.

# --hints--

`generateSlug("helloWorld")` should return `"helloworld"`.

```js
assert.equal(generateSlug("helloWorld"), "helloworld");
```

`generateSlug("hello world!")` should return `"hello%20world"`.

```js
assert.equal(generateSlug("hello world!"), "hello%20world");
```

`generateSlug(" hello-world ")` should return `"helloworld"`.

```js
assert.equal(generateSlug(" hello-world "), "helloworld");
```

`generateSlug("hello  world")` should return `"hello%20world"`.

```js
assert.equal(generateSlug("hello  world"), "hello%20world");
```

`generateSlug("  ?H^3-1*1]0! W[0%R#1]D  ")` should return `"h3110%20w0r1d"`.

```js
assert.equal(generateSlug("  ?H^3-1*1]0! W[0%R#1]D  "), "h3110%20w0r1d");
```

# --seed--

## --seed-contents--

```js
function generateSlug(str) {

  return str;
}
```

# --solutions--

```js
function generateSlug(str) {
  let cleaned = str.replace(/[^a-zA-Z0-9 ]+/g, "");
  cleaned = cleaned.replace(/\s+/g, " ").trim();
  return cleaned.toLowerCase().replace(/ /g, "%20");
}
```
