---
id: 68b1f72371a5ac895ac70a06
title: "Challenge 42: Video Storage"
challengeType: 28
dashedName: challenge-42
---

# --description--

Given a video size, a unit for the video size, a hard drive capacity, and a unit for the hard drive, return the number of videos the hard drive can store using the following constraints:

- The unit for the video size can be bytes (`"B"`), kilobytes (`"KB"`), megabytes (`"MB"`), or gigabytes (`"GB"`).
- If not given one of the video units above, return `"Invalid video unit"`.
- The unit of the hard drive capacity can be gigabytes (`"GB"`) or terabytes (`"TB"`).
- If not given one of the hard drive units above, return `"Invalid drive unit"`.
- Return the number of whole videos the drive can fit.
- Use the following conversions:

| Unit | Equivalent |
|:----:|:----------:|
| 1 B  |   1 B      |
| 1 KB |   1000 B   |
| 1 MB |   1000 KB  |
| 1 GB |   1000 MB  |
| 1 TB |   1000 GB  |

For example, given `500`, `"MB"`, `100`, and `"GB"` as arguments, determine how many 500 MB videos can fit on a 100 GB hard drive.

# --hints--

`numberOfVideos(500, "MB", 100, "GB")` should return `200`.

```js
assert.equal(numberOfVideos(500, "MB", 100, "GB"), 200);
```

`numberOfVideos(1, "TB", 10, "TB")` should return `"Invalid video unit"`.

```js
assert.equal(numberOfVideos(1, "TB", 10, "TB"), "Invalid video unit");
```

`numberOfVideos(2000, "MB", 100000, "MB")` should return `"Invalid drive unit"`.

```js
assert.equal(numberOfVideos(2000, "MB", 100000, "MB"), "Invalid drive unit");
```

`numberOfVideos(500000, "KB", 2, "TB")` should return `4000`.

```js
assert.equal(numberOfVideos(500000, "KB", 2, "TB"), 4000);
```

`numberOfVideos(1.5, "GB", 2.2, "TB")` should return `1466`.

```js
assert.equal(numberOfVideos(1.5, "GB", 2.2, "TB"), 1466);
```

# --seed--

## --seed-contents--

```js
function numberOfVideos(videoSize, videoUnit, driveSize, driveUnit) {

  return videoSize;
}
```

# --solutions--

```js
function numberOfVideos(videoSize, videoUnit, driveSize, driveUnit) {
  const videoUnits = { "KB": 1000, "MB": 1000 * 1000, "GB": 1000 * 1000 * 1000 };
  const driveUnits = { "GB": 1000 * 1000 * 1000, "TB": 1000 * 1000 * 1000 * 1000 };

  if (!videoUnits[videoUnit]) return "Invalid video unit";
  if (!driveUnits[driveUnit]) return "Invalid drive unit";

  const videoBytes = videoSize * videoUnits[videoUnit];
  const driveBytes = driveSize * driveUnits[driveUnit];

  return Math.floor(driveBytes / videoBytes);
}
```
