---
id: 68b1f72371a5ac895ac70a0a
title: "Challenge 44: String Mirror"
challengeType: 28
dashedName: challenge-44
---

# --description--

Given two strings, determine if the second string is a mirror of the first.

- A string is considered a mirror if it contains the same letters in reverse order.
- Treat uppercase and lowercase letters as distinct.
- Ignore all non-alphabetical characters.

# --hints--

`isMirror("helloworld", "helloworld")` should return `false`.

```js
assert.isFalse(isMirror("helloworld", "helloworld"));
```

`isMirror("Hello World", "dlroW olleH")` should return `true`.

```js
assert.isTrue(isMirror("Hello World", "dlroW olleH"));
```

`isMirror("RaceCar", "raCecaR")` should return `true`.

```js
assert.isTrue(isMirror("RaceCar", "raCecaR"));
```

`isMirror("RaceCar", "RaceCar")` should return `false`.

```js
assert.isFalse(isMirror("RaceCar", "RaceCar"));
```

`isMirror("Mirror", "rorrim")` should return `false`.

```js
assert.isFalse(isMirror("Mirror", "rorrim"));
```

`isMirror("Hello World", "dlroW-olleH")` should return `true`.

```js
assert.isTrue(isMirror("Hello World", "dlroW-olleH"));
```

`isMirror("Hello World", "!dlroW !olleH")` should return `true`.

```js
assert.isTrue(isMirror("Hello World", "!dlroW !olleH"));
```

# --seed--

## --seed-contents--

```js
function isMirror(str1, str2) {

  return str1;
}
```

# --solutions--

```js
function isMirror(str1, str2) {
  const clean1 = str1.replace(/[^a-zA-Z]/g, "");
  const clean2 = str2.replace(/[^a-zA-Z]/g, "");
  return clean1.split("").reverse().join("") === clean2;
}
```
