---
id: 68b7687dded630607aceccb1
title: "Challenge 48: Spam Detector"
challengeType: 28
dashedName: challenge-48
---

# --description--

Given a phone number in the format `"+A (BBB) CCC-DDDD"`, where each letter represents a digit as follows:

- `A` represents the country code and can be any number of digits.
- `BBB` represents the area code and will always be three digits.
- `CCC` and `DDDD` represent the local number and will always be three and four digits long, respectively.

Determine if it's a spam number based on the following criteria:

- The country code is greater than 2 digits long or doesn't begin with a zero (`0`).
- The area code is greater than 900 or less than 200.
- The sum of first three digits of the local number appears within last four digits of the local number.
- The number has the same digit four or more times in a row (ignoring the formatting characters).

# --hints--

`isSpam("+0 (200) 234-0182")` should return `false`.

```js
assert.isFalse(isSpam("+0 (200) 234-0182"));
```

`isSpam("+091 (555) 309-1922")` should return `true`.

```js
assert.isTrue(isSpam("+091 (555) 309-1922"));
```

`isSpam("+1 (555) 435-4792")` should return `true`.

```js
assert.isTrue(isSpam("+1 (555) 435-4792"));
```

`isSpam("+0 (955) 234-4364")` should return `true`.

```js
assert.isTrue(isSpam("+0 (955) 234-4364"));
```

`isSpam("+0 (155) 131-6943")` should return `true`.

```js
assert.isTrue(isSpam("+0 (155) 131-6943"));
```

`isSpam("+0 (555) 135-0192")` should return `true`.

```js
assert.isTrue(isSpam("+0 (555) 135-0192"));
```

`isSpam("+0 (555) 564-1987")` should return `true`.

```js
assert.isTrue(isSpam("+0 (555) 564-1987"));
```

`isSpam("+00 (555) 234-0182")` should return `false`.

```js
assert.isFalse(isSpam("+00 (555) 234-0182"));
```

# --seed--

## --seed-contents--

```js
function isSpam(number) {

  return number;
}
```

# --solutions--

```js
function isSpam(number) {
  const match = number.match(/^\+(\d+)\s\((\d{3})\)\s(\d{3})-(\d{4})$/);
  const [, countryCode, areaCode, ccc, dddd] = match;
  const allDigits = countryCode + areaCode + ccc + dddd;
  
  if (countryCode.length > 2 || !countryCode.startsWith("0")) return true;

  const areaNum = parseInt(areaCode, 10);
  if (areaNum > 900 || areaNum < 200) return true;

  const sumCCC = ccc.split("").reduce((a, b) => a + parseInt(b), 0);
  if (dddd.includes(sumCCC.toString())) return true;

  if (/(\d)\1\1\1/.test(allDigits)) return true;

  return false;
}
```
