---
id: 68b7cadffed0e75a517da677
title: "Challenge 54: P@ssw0rd Str3ngth!"
challengeType: 28
dashedName: challenge-54
---

# --description--

Given a password string, return `"weak"`, `"medium"`, or `"strong"` based on the strength of the password.

A password is evaluated according to the following rules:

- It is at least 8 characters long.
- It contains both uppercase and lowercase letters.
- It contains at least one number.
- It contains at least one special character from this set: `!`, `@`, `#`, `$`, `%`, `^`, `&`, or `*`.

Return `"weak"` if the password meets fewer than two of the rules.
Return `"medium"` if the password meets 2 or 3 of the rules.
Return `"strong"` if the password meets all 4 rules.

# --hints--

`checkStrength("123456")` should return `"weak"`.

```js
assert.equal(checkStrength("123456"), "weak");
```

`checkStrength("pass!!!")` should return `"weak"`.

```js
assert.equal(checkStrength("pass!!!"), "weak");
```

`checkStrength("Qwerty")` should return `"weak"`.

```js
assert.equal(checkStrength("Qwerty"), "weak");
```

`checkStrength("PASSWORD")` should return `"weak"`.

```js
assert.equal(checkStrength("PASSWORD"), "weak");
```

`checkStrength("PASSWORD!")` should return `"medium"`.

```js
assert.equal(checkStrength("PASSWORD!"), "medium");
```

`checkStrength("PassWord%^!")` should return `"medium"`.

```js
assert.equal(checkStrength("PassWord%^!"), "medium");
```

`checkStrength("qwerty12345")` should return `"medium"`.

```js
assert.equal(checkStrength("qwerty12345"), "medium");
```

`checkStrength("S3cur3P@ssw0rd")` should return `"strong"`.

```js
assert.equal(checkStrength("S3cur3P@ssw0rd"), "strong");
```

`checkStrength("C0d3&Fun!")` should return `"strong"`.

```js
assert.equal(checkStrength("C0d3&Fun!"), "strong");
```

# --seed--

## --seed-contents--

```js
function checkStrength(password) {

  return password;
}
```

# --solutions--

```js
function checkStrength(password) {
  let rulesMet = 0;

  if (password.length >= 8) rulesMet++;
  if (/[a-z]/.test(password) && /[A-Z]/.test(password)) rulesMet++;
  if (/\d/.test(password)) rulesMet++;
  if (/[!@#$%^&*]/.test(password)) rulesMet++;

  if (rulesMet < 2) return "weak";
  if (rulesMet < 4) return "medium";
  return "strong";
}
```
