---
id: 68c1a929005bf54d342aa8d6
title: "Challenge 59: Space Week Day 5: Goldilocks Zone"
challengeType: 28
dashedName: challenge-59
---

# --description--

For the fifth day of Space Week, you will calculate the "Goldilocks zone" of a star - the region around a star where conditions are "just right" for liquid water to exist.

Given the mass of a star, return an array with the start and end distances of its Goldilocks Zone in Astronomical Units.

To calculate the Goldilocks Zone:

1. Find the luminosity of the star by raising its mass to the power of 3.5.
2. The start of the zone is 0.95 times the square root of its luminosity.
3. The end of the zone is 1.37 times the square root of its luminosity.

- Return the distances rounded to two decimal places.

For example, given `1` as a mass, return `[0.95, 1.37]`.

# --hints--

`goldilocksZone(1)` should return `[0.95, 1.37]`.

```js
assert.deepEqual(goldilocksZone(1), [0.95, 1.37]);
```

`goldilocksZone(0.5)` should return `[0.28, 0.41]`.

```js
assert.deepEqual(goldilocksZone(0.5), [0.28, 0.41]);
```

`goldilocksZone(6)` should return `[21.85, 31.51]`.

```js
assert.deepEqual(goldilocksZone(6), [21.85, 31.51]);
```

`goldilocksZone(3.7)` should return `[9.38, 13.52]`.

```js
assert.deepEqual(goldilocksZone(3.7), [9.38, 13.52]);
```

`goldilocksZone(20)` should return `[179.69, 259.13]`.

```js
assert.deepEqual(goldilocksZone(20), [179.69, 259.13]);
```

# --seed--

## --seed-contents--

```js
function goldilocksZone(mass) {

  return mass;
}
```

# --solutions--

```js
function goldilocksZone(mass) {
  const luminosity = Math.pow(mass, 3.5);
  const start = 0.95 * Math.sqrt(luminosity);
  const end = 1.37 * Math.sqrt(luminosity);
  return [Number(start.toFixed(2)), Number(end.toFixed(2))];
}
```
