---
id: 68cae5b538ff798bbd4da002
title: "Challenge 64: 24 to 12"
challengeType: 28
dashedName: challenge-64
---

# --description--

Given a string representing a time of the day in the 24-hour format of `"HHMM"`, return the time in its equivalent 12-hour format of `"H:MM AM"` or `"H:MM PM"`.

- The given input will always be a four-digit string in 24-hour time format, from `"0000"` to `"2359"`.

# --hints--

`to12("1124")` should return `"11:24 AM"`.

```js
assert.equal(to12("1124"), "11:24 AM");
```

`to12("0900")` should return `"9:00 AM"`.

```js
assert.equal(to12("0900"), "9:00 AM");
```

`to12("1455")` should return `"2:55 PM"`.

```js
assert.equal(to12("1455"), "2:55 PM");
```

`to12("2346")` should return `"11:46 PM"`.

```js
assert.equal(to12("2346"), "11:46 PM");
```

`to12("0030")` should return `"12:30 AM"`.

```js
assert.equal(to12("0030"), "12:30 AM");
```

# --seed--

## --seed-contents--

```js
function to12(time) {

  return time;
}
```

# --solutions--

```js
function convertHours(hours) {
  if (hours === 0) return 12;
  if (hours > 12) return hours - 12;
  return hours;
}

function to12(time) {
  const hours = parseInt(time.slice(0, 2), 10);
  const minutes = time.slice(2);
  const period = hours < 12 ? 'AM' : 'PM';

  return `${convertHours(hours)}:${minutes} ${period}`;
}
```
