---
id: 68cae5b538ff798bbd4da00a
title: "Challenge 72: Thermostat Adjuster 2"
challengeType: 28
dashedName: challenge-72
---

# --description--

Given the current temperature of a room in Fahrenheit and a target temperature in Celsius, return a string indicating how to adjust the room temperature based on these constraints:

- Return `"Heat: X degrees Fahrenheit"` if the current temperature is below the target. With `X` being the number of degrees in Fahrenheit to heat the room to reach the target, rounded to 1 decimal place.
- Return `"Cool: X degrees Fahrenheit"` if the current temperature is above the target. With `X` being the number of degrees in Fahrenheit to cool the room to reach the target, rounded to 1 decimal place.
- Return `"Hold"` if the current temperature is equal to the target.

To convert Celsius to Fahrenheit, multiply the Celsius temperature by 1.8 and add 32 to the result (`F = (C * 1.8) + 32`).

# --hints--

`adjustThermostat(32, 0)` should return `"Hold"`.

```js
assert.equal(adjustThermostat(32, 0), "Hold");
```

`adjustThermostat(70, 25)` should return `"Heat: 7.0 degrees Fahrenheit"`.

```js
assert.equal(adjustThermostat(70, 25), "Heat: 7.0 degrees Fahrenheit");
```

`adjustThermostat(72, 18)` should return `"Cool: 7.6 degrees Fahrenheit"`.

```js
assert.equal(adjustThermostat(72, 18), "Cool: 7.6 degrees Fahrenheit");
```

`adjustThermostat(212, 100)` should return `"Hold"`.

```js
assert.equal(adjustThermostat(212, 100), "Hold");
```

`adjustThermostat(59, 22)` should return `"Heat: 12.6 degrees Fahrenheit"`.

```js
assert.equal(adjustThermostat(59, 22), "Heat: 12.6 degrees Fahrenheit");
```

# --seed--

## --seed-contents--

```js
function adjustThermostat(currentF, targetC) {

  return currentF;
}
```

# --solutions--

```js
function adjustThermostat(currentF, targetC) {
  const targetF = targetC * 1.8 + 32;
  const diff = Math.abs(targetF - currentF).toFixed(1);

  if (currentF < targetF) {
    return `Heat: ${diff} degrees Fahrenheit`;
  } else if (currentF > targetF) {
    return `Cool: ${diff} degrees Fahrenheit`;
  } else {
    return "Hold"
  }
}
```
