---
id: 68d30fc57588d97fd3027b30
title: "Challenge 79: Navigator"
challengeType: 28
dashedName: challenge-79
---

# --description--

On October 28, 1994, Netscape Navigator was released, helping millions explore the early web.

Given an array of browser commands you executed on Netscape Navigator, return the current page you are on after executing all the commands using the following rules:

- You always start on the `"Home"` page, which will not be included in the commands array.
- Valid commands are:
  - `"Visit Page"`: Where `"Page"` is the name of the page you are visiting. For example, `"Visit About"` takes you to the `"About"` page. When you visit a new page, make sure to discard any forward history you have.
  - `"Back"`: Takes you to the previous page in your history or stays on the current page if there isn't one.
  - `"Forward"`: Takes you forward in the history to the page you came from or stays on the current page if there isn't one.

For example, given `["Visit About Us", "Back", "Forward"]`, return `"About Us"`.

# --hints--

`navigate(["Visit About Us", "Back", "Forward"])` should return `"About Us"`.

```js
assert.equal(navigate(["Visit About Us", "Back", "Forward"]), "About Us");
```

`navigate(["Forward"])` should return `"Home"`.

```js
assert.equal(navigate(["Forward"]), "Home");
```

`navigate(["Back"])` should return `"Home"`.

```js
assert.equal(navigate(["Back"]), "Home");
```

`navigate(["Visit About Us", "Visit Gallery"])` should return `"Gallery"`.

```js
assert.equal(navigate(["Visit About Us", "Visit Gallery"]), "Gallery");
```

`navigate(["Visit About Us", "Visit Gallery", "Back", "Back"])` should return `"Home"`.

```js
assert.equal(navigate(["Visit About Us", "Visit Gallery", "Back", "Back"]), "Home");
```

`navigate(["Visit About", "Visit Gallery", "Back", "Visit Contact", "Forward"])` should return `"Contact"`.

```js
assert.equal(navigate(["Visit About", "Visit Gallery", "Back", "Visit Contact", "Forward"]), "Contact");
```

`navigate(["Visit About Us", "Visit Visit Us", "Forward", "Visit Contact Us", "Back"])` should return `"Visit Us"`.

```js
assert.equal(navigate(["Visit About Us", "Visit Visit Us", "Forward", "Visit Contact Us", "Back"]), "Visit Us");
```

# --seed--

## --seed-contents--

```js
function navigate(commands) {

  return commands;
}
```

# --solutions--

```js
function navigate(commands) {
  const history = ["Home"];
  let currentPageIndex = 0;

  for (const command of commands) {
    if (command.startsWith("Visit")) {
      history.splice(currentPageIndex + 1);
      history.push(command.slice(6));
      currentPageIndex++;
    } else if(command === "Back" && currentPageIndex > 0) {
      currentPageIndex--;
    } else if (command === "Forward" && currentPageIndex < history.length - 1) {
      currentPageIndex++;
    }
  }

  return history[currentPageIndex];
}
```
