---
id: 68f6587287ad1f4ad39b0c80
title: "Challenge 94: Email Signature Generator"
challengeType: 28
dashedName: challenge-94
---

# --description--

Given strings for a person's name, title, and company, return an email signature as a single string using the following rules:

- The name should appear first, preceded by a prefix that depends on the first letter of the name. For names starting with (case-insensitive):
  - `A-I`: Use `>>` as the prefix.
  - `J-R`: Use `--` as the prefix.
  - `S-Z`: Use `::` as the prefix.
- A comma and space (`, `) should follow the name.
- The title and company should follow the comma and space, separated by `" at "` (with spaces around it).

For example, given `"Quinn Waverly"`, `"Founder and CEO"`, and `"TechCo"` return `"--Quinn Waverly, Founder and CEO at TechCo"`.

# --hints--

`generateSignature("Quinn Waverly", "Founder and CEO", "TechCo")` should return `"--Quinn Waverly, Founder and CEO at TechCo"`.

```js
assert.equal(generateSignature("Quinn Waverly", "Founder and CEO", "TechCo"), "--Quinn Waverly, Founder and CEO at TechCo");
```

`generateSignature("Alice Reed", "Engineer", "TechCo")` should return `">>Alice Reed, Engineer at TechCo"`.

```js
assert.equal(generateSignature("Alice Reed", "Engineer", "TechCo"), ">>Alice Reed, Engineer at TechCo");
```

`generateSignature("Tina Vaughn", "Developer", "example.com")` should return `"::Tina Vaughn, Developer at example.com"`.

```js
assert.equal(generateSignature("Tina Vaughn", "Developer", "example.com"), "::Tina Vaughn, Developer at example.com");
```

`generateSignature("B. B.", "Product Tester", "AcmeCorp")` should return `">>B. B., Product Tester at AcmeCorp"`.

```js
assert.equal(generateSignature("B. B.", "Product Tester", "AcmeCorp"), ">>B. B., Product Tester at AcmeCorp");
```

`generateSignature("windstorm", "Cloud Architect", "Atmospheronics")` should return `"::windstorm, Cloud Architect at Atmospheronics"`.

```js
assert.equal(generateSignature("windstorm", "Cloud Architect", "Atmospheronics"), "::windstorm, Cloud Architect at Atmospheronics");
```

# --seed--

## --seed-contents--

```js
function generateSignature(name, title, company) {

  return name;
}
```

# --solutions--

```js
function generateSignature(name, title, company) {
  const firstLetter = name[0].toUpperCase();
  let prefix;
  if ("ABCDEFGHI".includes(firstLetter)) {
    prefix = ">>";
  } else if ("JKLMNOPQR".includes(firstLetter)) {
    prefix = "--";
  } else {
    prefix = "::";
  }

  return `${prefix}${name}, ${title} at ${company}`;
}
```
