---
id: 68f6587287ad1f4ad39b0c82
title: "Challenge 96: Is It the Weekend?"
challengeType: 28
dashedName: challenge-96
---

# --description--

Given a date in the format `"YYYY-MM-DD"`, return the number of days left until the weekend.

- The weekend starts on Saturday.
- If the given date is Saturday or Sunday, return `"It's the weekend!"`.
- Otherwise, return `"X days until the weekend."`, where `X` is the number of days until Saturday.
- If `X` is `1`, use `"day"` (singular) instead of `"days"` (plural).
- Make sure the calculation ignores your local timezone.

# --hints--

`daysUntilWeekend("2025-11-14")` should return `"1 day until the weekend."`.

```js
assert.equal(daysUntilWeekend("2025-11-14"), "1 day until the weekend.");
```

`daysUntilWeekend("2025-01-01")` should return `"3 days until the weekend."`.

```js
assert.equal(daysUntilWeekend("2025-01-01"), "3 days until the weekend.");
```

`daysUntilWeekend("2025-12-06")` should return `"It's the weekend!"`.

```js
assert.equal(daysUntilWeekend("2025-12-06"), "It's the weekend!");
```

`daysUntilWeekend("2026-01-27")` should return `"4 days until the weekend."`.

```js
assert.equal(daysUntilWeekend("2026-01-27"), "4 days until the weekend.");
```

`daysUntilWeekend("2026-09-07")` should return `"5 days until the weekend."`.

```js
assert.equal(daysUntilWeekend("2026-09-07"), "5 days until the weekend.");
```

`daysUntilWeekend("2026-11-29")` should return `"It's the weekend!"`.

```js
assert.equal(daysUntilWeekend("2026-11-29"), "It's the weekend!");
```

# --seed--

## --seed-contents--

```js
function daysUntilWeekend(dateString) {

  return dateString;
}
```

# --solutions--

```js
function daysUntilWeekend(dateString) {
  const [year, month, day] = dateString.split("-").map(Number);
  const date = new Date(Date.UTC(year, month - 1, day));

  const dayOfWeek = date.getUTCDay();

  if (dayOfWeek === 6 || dayOfWeek === 0) {
    return "It's the weekend!";
  }

  const daysUntilSaturday = (6 - dayOfWeek);
  return `${daysUntilSaturday} day${daysUntilSaturday === 1 ? "" : "s"} until the weekend.`;
}
```
