---
id: 68ffb91507a5b645769328cc
title: "Challenge 109: What's My Age Again?"
challengeType: 28
dashedName: challenge-109
---

# --description--

Given the date of someone's birthday in the format `YYYY-MM-DD`, return the person's age as of November 27th, 2025.

- Assume all birthdays are valid dates before November 27th, 2025.
- Return the age as an integer.
- Be sure to account for whether the person has already had their birthday in 2025.

# --hints--

`calculateAge("2000-11-20")` should return `25`.

```js
assert.equal(calculateAge("2000-11-20"), 25);
```

`calculateAge("2000-12-01")` should return `24`.

```js
assert.equal(calculateAge("2000-12-01"), 24);
```

`calculateAge("2014-10-25")` should return `11`.

```js
assert.equal(calculateAge("2014-10-25"), 11);
```

`calculateAge("1994-01-06")` should return `31`.

```js
assert.equal(calculateAge("1994-01-06"), 31);
```

`calculateAge("1994-12-14")` should return `30`.

```js
assert.equal(calculateAge("1994-12-14"), 30);
```

# --seed--

## --seed-contents--

```js
function calculateAge(birthday) {

  return birthday;
}
```

# --solutions--

```js
function calculateAge(birthday) {
  const today = new Date("2025-11-27");
  const [year, month, day] = birthday.split("-").map(Number);
  const birthDate = new Date(year, month - 1, day);

  let age = today.getFullYear() - birthDate.getFullYear();

  if (
    today.getMonth() < birthDate.getMonth() ||
    (today.getMonth() === birthDate.getMonth() && today.getDate() < birthDate.getDate())
  ) {
    age--;
  }

  return age;
}
```
