---
id: 6925e2068081f40f549ced1b
title: "Challenge 137: Snowflake Generator"
challengeType: 28
dashedName: challenge-137
---

# --description--

Given a multi-line string that uses newline characters (`\n`) to represent a line break, return a new string where each line is mirrored horizontally and attached to the end of the original line.

- Mirror a line by reversing all of its characters, including spaces.

For example, given `"* \n *\n* "`, which logs to the console as:

```sh
* 
 *
* 
```

Return `"*  *\n ** \n*  *"`, which logs to the console as:

```sh
*  *
 ** 
*  *
```

Take careful note of the whitespaces in the given and returned strings. Be sure not to trim any of them.

# --hints--

`generateSnowflake("* \n *\n* ")` should return `"*  *\n ** \n*  *"`.

```js
assert.equal(generateSnowflake("* \n *\n* "), "*  *\n ** \n*  *");
```

`generateSnowflake("X=~")` should return `"X=~~=X"`.

```js
assert.equal(generateSnowflake("X=~"), "X=~~=X");
```

`generateSnowflake(" X  \n  v \nX--=\n  ^ \n X  ")` should return `" X    X \n  v  v  \nX--==--X\n  ^  ^  \n X    X "`.

```js
assert.equal(generateSnowflake(" X  \n  v \nX--=\n  ^ \n X  "), " X    X \n  v  v  \nX--==--X\n  ^  ^  \n X    X ");
```

`generateSnowflake("*   *\n * * \n* * *\n * * \n*   *")` should return `"*   **   *\n * *  * * \n* * ** * *\n * *  * * \n*   **   *"`.

```js
assert.equal(generateSnowflake("*   *\n * * \n* * *\n * * \n*   *"), "*   **   *\n * *  * * \n* * ** * *\n * *  * * \n*   **   *");
```

`generateSnowflake("*  -\n * -\n*  -")` should return `"*  --  *\n * -- * \n*  --  *"`.

```js
assert.equal(generateSnowflake("*  -\n * -\n*  -"), "*  --  *\n * -- * \n*  --  *");
```

# --seed--

## --seed-contents--

```js
function generateSnowflake(crystals) {

  return crystals;
}
```

# --solutions--

```js
function generateSnowflake(crystals) {
  const lines = crystals.split("\n");

  const mirroredLines = lines.map(line => {
    const reversed = line.split("").reverse().join("");
    return line + reversed;
  });

  return mirroredLines.join("\n");
}
```
