---
id: 69272dcf1c24b44fd79137c6
title: "Challenge 143: Markdown Italic Parser"
challengeType: 28
dashedName: challenge-143
---

# --description--

Given a string that may include some italic text in Markdown, return the equivalent HTML string.

- Italic text in Markdown is any text that starts and ends with a single asterisk (`*`) or a single underscore (`_`).
- There cannot be any spaces between the text and the asterisk or underscore, but there can be spaces in the text itself.
- Convert all italic occurrences to HTML `i` tags and return the string.

For example, given `"*This is italic*"`, return `"<i>This is italic</i>"`.

Note: The console may not display HTML tags in strings when logging messages. Check the browser console to see logs with tags included.

# --hints--

`parseItalics("*This is italic*")` should return `"<i>This is italic</i>"`.

```js
assert.equal(parseItalics("*This is italic*"), "<i>This is italic</i>");
```

`parseItalics("_This is also italic_")` should return `"<i>This is also italic</i>"`.

```js
assert.equal(parseItalics("_This is also italic_"), "<i>This is also italic</i>");
```

`parseItalics("*This is not italic *")` should return `"*This is not italic *"`.

```js
assert.equal(parseItalics("*This is not italic *"), "*This is not italic *");
```

`parseItalics("_ This is also not italic_")` should return `"_ This is also not italic_"`.

```js
assert.equal(parseItalics("_ This is also not italic_"), "_ This is also not italic_");
```

`parseItalics("The *quick* brown fox _jumps_ over the *lazy* dog.")` should return `"The <i>quick</i> brown fox <i>jumps</i> over the <i>lazy</i> dog."`.

```js
assert.equal(parseItalics("The *quick* brown fox _jumps_ over the *lazy* dog."), "The <i>quick</i> brown fox <i>jumps</i> over the <i>lazy</i> dog.");
```

# --seed--

## --seed-contents--

```js
function parseItalics(markdown) {

  return markdown;
}
```

# --solutions--

```js
function parseItalics(markdown) {
  return markdown.replace(/(\*|_)([^\s][^]*?[^\s])\1/g, '<i>$2</i>');
}
```
