---
id: 6939b873185d8e00d453563e
title: "Challenge 159: Integer Hypotenuse"
challengeType: 28
dashedName: challenge-159
---

# --description--

Given two positive integers representing the lengths for the two legs (the two short sides) of a right triangle, determine whether the hypotenuse is an integer.

The length of the hypotenuse is calculated by adding the squares of the two leg lengths together and then taking the square root of that total (a<sup>2</sup> + b<sup>2</sup> = c<sup>2</sup>).

# --hints--

`isIntegerHypotenuse(3, 4)` should return `true`.

```js
assert.isTrue(isIntegerHypotenuse(3, 4));
```

`isIntegerHypotenuse(2, 3)` should return `false`.

```js
assert.isFalse(isIntegerHypotenuse(2, 3));
```

`isIntegerHypotenuse(5, 12)` should return `true`.

```js
assert.isTrue(isIntegerHypotenuse(5, 12));
```

`isIntegerHypotenuse(10, 10)` should return `false`.

```js
assert.isFalse(isIntegerHypotenuse(10, 10));
```

`isIntegerHypotenuse(780, 1040)` should return `true`.

```js
assert.isTrue(isIntegerHypotenuse(780, 1040));
```

`isIntegerHypotenuse(250, 333)` should return `false`.

```js
assert.isFalse(isIntegerHypotenuse(250, 333));
```

# --seed--

## --seed-contents--

```js
function isIntegerHypotenuse(a, b) {

  return a;
}
```

# --solutions--

```js
function isIntegerHypotenuse(a, b) {
  const sum = a * a + b * b;
  const c = Math.floor(Math.sqrt(sum));
  return c * c === sum;
}
```
