---
id: 69162d64f96574d9bb629efd
title: "Challenge 112: AI Detector"
challengeType: 29
dashedName: challenge-112
---

# --description--

Today's challenge is inspired by the release of ChatGPT on November 30, 2022.

Given a string of one or more sentences, determine if it was likely generated by AI using the following rules:

- It contains two or more dashes (`-`).
- It contains two or more sets of parenthesis (`()`). Text can be within the parenthesis.
- It contains three or more words with 7 or more letters.

- Words are separated by a single space and only consist of letters (`A-Z`). Don't include punctuation or other non-letters as part of a word.

If the given sentence meets any of the rules above, return `"AI"`, otherwise, return `"Human"`.

# --hints--

`detect_ai("The quick brown fox jumped over the lazy dog.")` should return `"Human"`.

```js
({test: () => { runPython(`
from unittest import TestCase
TestCase().assertEqual(detect_ai("The quick brown fox jumped over the lazy dog."), "Human")`)
}})
```

`detect_ai("The hypersonic brown fox - jumped (over) the lazy dog.")` should return `"Human"`.

```js
({test: () => { runPython(`
from unittest import TestCase
TestCase().assertEqual(detect_ai("The hypersonic brown fox - jumped (over) the lazy dog."), "Human")`)
}})
```

`detect_ai("Yes - you're right! I made a mistake there - let me try again.")` should return `"AI"`.

```js
({test: () => { runPython(`
from unittest import TestCase
TestCase().assertEqual(detect_ai("Yes - you're right! I made a mistake there - let me try again."), "AI")`)
}})
```

`detect_ai("The extraordinary students were studying vivaciously.")` should return `"AI"`.

```js
({test: () => { runPython(`
from unittest import TestCase
TestCase().assertEqual(detect_ai("The extraordinary students were studying vivaciously."), "AI")`)
}})
```

`detect_ai("The (excited) student was (coding) in the library.")` should return `"AI"`.

```js
({test: () => { runPython(`
from unittest import TestCase
TestCase().assertEqual(detect_ai("The (excited) student was (coding) in the library."), "AI")`)
}})
```

# --seed--

## --seed-contents--

```py
def detect_ai(text):

    return text
```

# --solutions--

```py
import re
def detect_ai(text):
    if len(re.findall(r'-', text)) >= 2:
        return "AI"

    if len(re.findall(r'\([^)]*\)', text)) >= 2:
        return "AI"

    words = text.split()
    long_word_count = sum(1 for w in words if len(re.sub(r'[^A-Za-z]', '', w)) >= 7)
    if long_word_count >= 3:
        return "AI"

    return "Human"
```
