---
id: 587d8248367417b2b2512c3a
title: Avoid Inferring the Response MIME Type with helmet.noSniff()
challengeType: 2
forumTopicId: 301574
dashedName: avoid-inferring-the-response-mime-type-with-helmet-nosniff
---

# --description--

As a reminder, this project is being built upon the following starter project cloned from <a href="https://github.com/freeCodeCamp/boilerplate-infosec/" target="_blank" rel="noopener noreferrer nofollow">GitHub</a>.

Browsers can use content or MIME sniffing to override the `Content-Type` header of a response to guess and process the data using an implicit content type. While this can be convenient in some scenarios, it can also lead to some dangerous attacks. This middleware sets the `X-Content-Type-Options` header to `nosniff`, instructing the browser to not bypass the provided `Content-Type`.

# --instructions--

Use the `helmet.noSniff()` method on your server.

# --hints--

helmet.noSniff() middleware should be mounted correctly

```js
const response = await fetch(code + '/_api/app-info');
if (!response.ok) {
  throw Error(await response.text());
}
const data = await response.json();
assert.include(data.appStack, 'nosniff');
assert.equal(data.headers['x-content-type-options'], 'nosniff');
```

