---
id: 587d8248367417b2b2512c3d
title: Disable DNS Prefetching with helmet.dnsPrefetchControl()
challengeType: 2
forumTopicId: 301577
dashedName: disable-dns-prefetching-with-helmet-dnsprefetchcontrol
---

# --description--

As a reminder, this project is being built upon the following starter project cloned from <a href="https://github.com/freeCodeCamp/boilerplate-infosec/" target="_blank" rel="noopener noreferrer nofollow">GitHub</a>.

To improve performance, most browsers prefetch DNS records for the links in a page. In that way the destination ip is already known when the user clicks on a link. This may lead to over-use of the DNS service (if you own a big website, visited by millions people…), privacy issues (one eavesdropper could infer that you are on a certain page), or page statistics alteration (some links may appear visited even if they are not). If you have high security needs you can disable DNS prefetching, at the cost of a performance penalty.

# --instructions--

Use the `helmet.dnsPrefetchControl()` method on your server.

# --hints--

helmet.dnsPrefetchControl() middleware should be mounted correctly

```js
const response = await fetch(code + '/_api/app-info');
if (!response.ok) {
  throw Error(await response.text());
}
const data = await response.json();
assert.include(data.appStack, 'dnsPrefetchControl');
assert.equal(data.headers['x-dns-prefetch-control'], 'off');
```

