---
id: 67172b43f84bcd2dec238a3d
title: Build a Book Organizer
challengeType: 26
dashedName: build-a-book-organizer
---

# --description--

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab. 

**User Stories:**

1. You should have an array of objects named `books` where each object in the array should have a string `title`, another string `authorName`, and a number `releaseYear`. 

2. Your `books` array should have a minimum of three objects.

3. You should have a callback function named `sortByYear` that accepts two books as parameter for sorting the array.

4. The `sortByYear` function should return `-1` if the `releaseYear` of the first book is smaller than that of the second book.

5. The `sortByYear` function should return `1` if the `releaseYear` of the first book is bigger than that of the second book.

6. The `sortByYear` function should return `0` if both `releaseYear` values are equal.

7. You should filter out books written after a certain year such as 1950 from the `books` array and save the filtered array in a new array named `filteredBooks`.

8. You should sort the books in the `filteredBooks` array according to their `releaseYear` in ascending order. You learned in a prior lesson that the `sort()` method will sort the array in place. This means the `filteredBooks` array will be mutated. 

# --hints--

You should have a function `sortByYear` in your code.

```js
assert.isFunction(sortByYear);
```

Your `sortByYear` function should take two parameters.

```js
assert.lengthOf(sortByYear, 2);
```

Your `sortByYear` function should return `-1` if the `releaseYear` of `book1` object is smaller than that of the `book2` object, `1` if the `releaseYear` of `book1` object is larger than that of the `book2` object, and `0` in all other scenarios.

```js
assert.equal(sortByYear({releaseYear: 1913}, {releaseYear: 1925}), -1);
assert.equal(sortByYear({releaseYear: 1925}, {releaseYear: 1913}), 1);
assert.equal(sortByYear({releaseYear: 1925}, {releaseYear: 1925}), 0);
```

You should have an array `books` in your code.

```js
assert.isArray(books)
```

Your `books` array should have at least three book objects.

```js
assert.isAtLeast(books.length, 3)
```

Your `books` array should contain objects each with a string `title`, another string `authorName`, and a number `releaseYear`.

```js

books.forEach((book) => {
  assert.isObject(book);
  assert.sameMembers(Object.keys(book), ["title", "authorName", "releaseYear"]);
  assert.isString(book.title);
  assert.isNotEmpty(book.title);
  assert.isString(book.authorName);
  assert.isNotEmpty(book.authorName);
  assert.isNumber(book.releaseYear);
})
```

You should have an array `filteredBooks` in your code.

```js
assert.isArray(filteredBooks)
```

The `filteredBooks` array should have some of the books filtered out from the `books` array and not be empty.

```js
assert.isBelow(filteredBooks.length, books.length)
assert.isNotEmpty(filteredBooks)
```

The `filteredBooks` array should only contain books from the original `books` array.

```js
filteredBooks.forEach(book => {
  assert.isTrue(
    books.some(original => 
      original.title === book.title &&
      original.authorName === book.authorName &&
      original.releaseYear === book.releaseYear
    )
  );
});
```

The `filteredBooks` array should include only books released on or before a specified year.

```js
const maxYear = Math.max(...filteredBooks.map(book => book.releaseYear));
const removedYears = books.filter(book => !filteredBooks.includes(book)).map(book => book.releaseYear);
assert.isTrue(removedYears.every(year => year > maxYear));
```

You should call the `sort` higher order function by passing the `sortByYear` callback function on the `filteredBooks` array.

```js
assert.match(__helpers.removeJSComments(code), /\s*filteredBooks\s*\.\s*sort\s*\(\s*sortByYear\s*\)/);
```

# --seed--

## --seed-contents--

```js

```

# --solutions--

```js
function sortByYear(book1, book2) {
  if (book1.releaseYear < book2.releaseYear) {
    return -1;
  }

  if (book1.releaseYear > book2.releaseYear) {
    return 1;
  }

  return 0;
}

const books = [
  {
    title: "The Great Gatsby",
    authorName: "F. Scott Fitzgerald",
    releaseYear: 1925,
  },
  {
    title: "In Search of Lost Time",
    authorName: "Marcel Proust",
    releaseYear: 1913,
  },
  {
    title: "Ulysses",
    authorName: "James Joyce",
    releaseYear: 1922,
  },
  {
    title: "One Hundred Years of Solitude",
    authorName: "Gabriel García Márquez",
    releaseYear: 1967,
  },
  {
    title: "The Catcher in the Rye",
    authorName: "J. D. Salinger",
    releaseYear: 1951,
  },
];

let filteredBooks = books.filter((book) => book.releaseYear < 1950);

filteredBooks.sort(sortByYear);

console.log("Books Written Before 1950 (sorted according to release year)");
filteredBooks.forEach((book) => {
  console.log(`${book.title} by ${book.authorName} (${book.releaseYear})`);
});
```
