---
id: 6690e10ebe2181212abc9652
title: Design a Business Card
challengeType: 25
dashedName: design-a-business-card
demoType: onClick
---

# --description--

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should have a `div` with a `class` attribute with a value of `business-card` that will contain all the other elements. 
1. Inside the `.business-card` element, there should be an `img` element with a `class` attribute with a value of `profile-image`. You can set the image source to `https://cdn.freecodecamp.org/curriculum/labs/flower.jpg` if you like. There should be an `alt` with a meaningful description.
1. Inside the `.business-card` element, after the `img` element, you should have three `p` elements with a `class` attribute that has, respectively, a value of `full-name`, `designation`, and `company`.
1. The first `p` element should contain your name.
1. The second `p` element should contain your designation.
1. The third `p` element should have your company name. 
1. There should be an `hr` element below the third `p` element.
1. After the `hr` element, there should be two `p` elements. In the first `p` element, you should have an email address as the text. In the second `p` element, the text should be a phone number.
1. After the two `p` elements, there should be an `a` element with a class of `portfolio-link`, the text `Portfolio`, and it should link to a valid URL.
1. There should be an `hr` element after the `a` element containing the portfolio link.
1. You should have another `div` element with a `class` attribute with a value of `social-media`. Within this element, there should be an `h2` element with the text `Connect with me`. 
1. Inside the `.social-media` elements, there should be three `a` elements. The `a` elements should have the text `Twitter`, `LinkedIn` and `GitHub` respectively with links to valid websites.
1. You should link the style sheet `styles.css` using the `link` tag in the `head` section of the HTML file.
1. Your page background should be `rosybrown`. The overall font should be `Arial`, with a fallback of `sans-serif`.   
1. The `.business-card` selector should have properties to set the element as `300px` wide and a background color of your choice. Also you should set a `padding` of `20px` all around and a top `margin` of `100px`. The text should be center aligned and the font size should be `16px`. The left and right margins should be set to `auto`.
1. The `.profile-image` selector should have a `max-width` property with a value of `100%`.
1. All of the `p` elements should have a top and bottom `margin` of `5px`.
1. All links on the page should not be underlined.

# --hints--

You should have one main `div` with a `class` attribute with a value of `business-card`.

```js
assert.strictEqual(document.querySelector('div')?.getAttribute('class'), 'business-card');
```

Inside the `.business-card` element, there should be an `img` element with a `class` attribute with a value of`profile-image`.

```js
assert.exists(document.querySelector('img.profile-image'));
```

The image source should be set to a valid image.

```js
assert.isAbove(document.querySelector('.profile-image')?.getAttribute('src')?.length, 0);
```

The `alt` attribute of the image should be set to a meaningful description.

```js
assert.isAbove(document.querySelector('img')?.alt.length, 0);
```

Inside the `.business-card` element, after the `img` element, there should be a `p` element with a `class` attribute with a value of `full-name`.

```js
assert.exists(document.querySelector('div.business-card p.full-name'));
```

After the `.full-name` element, there should be a `p` element with a `class` attribute with a value of`designation`.

```js
assert.exists(document.querySelector('div.business-card p.designation'));
```

After the `.designation` element, there should be a `p` element with a `class` attribute with a value of `company`.

```js
assert.exists(document.querySelector('div.business-card p.company'));
```

The first `p` element, the one with class of `full-name`, should contain your name.

```js
assert.isNotEmpty(document.querySelector(".full-name")?.innerText.trim());
```

The second `p` element, the one with a `class` attribute of `designation`, should contain your designation.

```js
assert.isNotEmpty(document.querySelector(".designation")?.innerText.trim());
```

The third `p` element, the one with the `class` attribute with a value of`company`, should contain your company name.

```js
assert.isNotEmpty(document.querySelector(".company")?.innerText.trim());
```

After the third `p` element, the one with the `class` attribute with a value of `company`, there should be an `hr` element.

```js
assert.exists(document.querySelector('p.company + hr'));
```

After the first `hr` element, there should be a `p` element with an email address as your text.

```js
assert.isNotEmpty(document.querySelectorAll('.business-card hr + p')[0].innerText.trim());
```

After the email `p` element, there should be another `p` element with a phone number as your text.

```js
assert.match(document.querySelectorAll(".business-card p")[4].textContent,/.+/);
```

After the phone number `p` element, there should be an `a` element with the class `portfolio-link`. 

```js
assert.exists(document.querySelector('a.portfolio-link'));
```

The `.portfolio-link` element should have text of `Portfolio`.

```js
assert.equal(document.querySelector('a.portfolio-link').innerText.trim(), 'Portfolio');
```

Your `.portfolio-link` element should have a valid `href`.

```js
assert.isAbove(document.querySelector('.portfolio-link').getAttribute('href').length, 0);
```

After the `a` element containing your portfolio, there should be another `hr` element as a divider.

```js
assert.exists(document.querySelector('a + hr'));
```

After the second `hr` element, there should be a `div` element with a `class` attribute with a value of `social-media`.

```js
assert.exists(document.querySelector('div.business-card div.social-media'));
```

Inside the `.social-media` element, there should be an `h2` element with the text `Connect with me`.

```js
assert.equal(document.querySelector('.social-media h2')?.textContent.trim(), 'Connect with me');
```

Inside the `.social-media` element there should be three `a` elements.

```js
assert.lengthOf(document.querySelectorAll('.social-media a'), 3);
```

The first `a` element should have the text `Twitter`.

```js
assert.equal(document.querySelectorAll(".social-media a")[0]?.textContent.trim(), 'Twitter');
```

The `href` of the first `a` element should point to a valid link.

```js
assert.isAbove(document.querySelectorAll('.social-media a')[0]?.getAttribute('href')?.length, 0);
```

The second `a` element should have the text `LinkedIn`.

```js

assert.equal(document.querySelectorAll(".social-media a")[1]?.textContent.trim(), 'LinkedIn');
```

The `href` of the second `a` element should point to a valid link.

```js
assert.isAbove(document.querySelectorAll('.social-media a')[1]?.getAttribute('href')?.length, 0);
```

The third `a` element should have the text `GitHub`.

```js
assert.equal(document.querySelectorAll(".social-media a")[2]?.textContent.trim(), 'GitHub');
```

The `href` of the third `a` element should point to a valid link.

```js
assert.isAbove(document.querySelectorAll('.social-media a')[2]?.getAttribute('href')?.length, 0);
```

Your `link` element should be within your `head` element.

```js
const link = document.querySelector('head > link');
assert.isNotNull(link);
```

Your `link` element should have a `rel` attribute with the value `stylesheet`.

```js
const linkRelValue = document.querySelector('link')?.getAttribute('rel');
assert.strictEqual(linkRelValue, 'stylesheet');
```

Your `link` element should have an `href` attribute with the value `styles.css`.

```js
const linkHrefValue = document.querySelector('link')?.dataset?.href;
assert.strictEqual(linkHrefValue, 'styles.css');
```

You should set the page background color in the `body` selector to `rosybrown`.

```js
assert.strictEqual(new __helpers.CSSHelp(document).getStyle('body')?.getPropVal('background-color'), 'rosybrown');
```

You should set the page font to `Arial` in the `body` element with a fallback of `sans-serif`.

```js
const el = new __helpers.CSSHelp(document).getStyle('body')?.getPropVal('font-family');
const condition1= el === 'Arial, sans-serif';
const condition2= el === '"Arial", sans-serif';
assert.isTrue(condition1 || condition2);
```

Your `.business-card` selector should have a `width` property with a value of `300px`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.business-card')?.getPropVal('width'), '300px');
```

Your `.business-card` selector should have a `background-color` property with a valid color value.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle('.business-card')?.backgroundColor);
```

Your `.business-card` selector should have a `padding` property with a value of `20px`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.business-card')?.getPropVal('padding'), '20px');
```

Your `.business-card` selector should have a top margin of `100px`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.business-card')?.getPropVal('margin-top'), '100px');
```

The text inside the `.business-card` element should be center-aligned.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.business-card')?.getPropVal('text-align'), 'center');
```

The font size of the text inside the `.business-card` element should be `16px`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.business-card')?.getPropVal('font-size'), '16px');
```

The left and right margins of the `.business-card` element should be set to `auto`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.business-card')?.getPropVal('margin-left'), 'auto');
assert.equal(new __helpers.CSSHelp(document).getStyle('.business-card')?.getPropVal('margin-right'), 'auto');
```

Your `.profile-image` selector should have a `max-width` property with a value of `100%`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.profile-image')?.getPropVal('max-width'), '100%');
```

Your `p` elements should have a top and bottom `margin` of `5px`.

```js
const marginTop = new __helpers.CSSHelp(document).getStyle('p')?.getPropVal('margin-top');
const marginBottom = new __helpers.CSSHelp(document).getStyle('p')?.getPropVal('margin-bottom');

assert.equal(marginTop, '5px');
assert.equal(marginBottom, '5px');
```

The links of the page should have no underline.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('a')?.getPropVal('text-decoration'), 'none');
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Business Card</title>
</head>

<body>

</body>

</html>
```

```css

```

# --solutions--

```html
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Digital Business Card</title>
    <link rel="stylesheet" href="styles.css">
</head>

<body>
    <div class="business-card">
        <img src="https://cdn.freecodecamp.org/curriculum/labs/flower.jpg" alt="A vibrant flower in full bloom" class="profile-image">
        <p class="full-name">Your Name</p>
        <p class="designation">Software Developer</p>
        <p class="company" >@freeCodeCamp</p>
        <hr>
        <p>Email: your-email@example.com</p>
        <p>Phone: (123) 456-7890</p>
        <a class="portfolio-link" href="http://example.com">Portfolio</a>
        <hr>
        <div class="social-media">
            <h2>Connect with me</h2>
            <a href="http://twitter.com/">Twitter</a>
            <a href="http://linkedin.com/">LinkedIn</a>
            <a href="http://github.com/">GitHub</a>
        </div>
    </div>
</body>

</html>

```

```css
body {
    background-color: rosybrown;
    font-family: 'Arial', sans-serif;
}

.business-card {
    background-color: lavenderblush;
    border: 3px solid darkslategray;
    padding: 20px;
    text-align: center;
    font-size: 16px;
    width: 300px;
    margin-left: auto;
    margin-right: auto;
    margin-top: 100px;
}

.profile-image {
    max-width: 100%;
    width: 150px;
    height: 150px;
    margin-bottom: 10px;
    border: 2px solid lightgray;
}

.full-name {
    font-size: 24px;
    color: darkslategray;
}

.designation {
    font-size: 18px;
    color: gray;
}

.company {
    font-size: 16px;
    color: darkgray;
}

p {
    margin: 5px 0;
}

a {
    text-decoration: none;
}

.social-media {
    margin-top: 10px;
    font-size: 14px;
}

.social-media a {
    margin: 10px;
    color: maroon
}

hr {
    margin: 20px 0;
}
```
