---
id: 66bba6fff611169359d9d36a
title: Build a Confidential Email Page
challengeType: 25
dashedName: build-a-confidential-email-page
demoType: onClick
---

# --description--

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should have a `main` element with an `id` of `email`.
1. Your `#email` element should have `padding` of `50px`, a top margin of `50px`, a `width` of `500px`, and a `border` that's `2px`.
1. The total width of your `#email` element, including paddings and borders, should be `500px`.
1. You should have two `div` elements, one with an id of `confidential` and the other with an id of `top-secret`, within your `#email` element.
1. Your `#confidential` and `#top-secret` elements should have a `display` of `inline-block`.
1. Your `#confidential` and `#top-secret` elements should have a `padding`, a left margin, and a `border`.
1. The `#confidential` element should have the text `CONFIDENTIAL`.
1. The `#top-secret` element should have the text `TOP SECRET`.
1. Your `#confidential` and `#top-secret` elements should be rotated using a CSS transform.
1. You should have at least three paragraph elements within your `#email` element.
1. You should have at least three `span` elements with a class of `blurred`, within your paragraph elements.
1. You should have a `blurred` selector that blurs the element `3px` using a CSS filter.

# --hints--

You should have a `main` element with an `id` of `email`.

```js
assert.exists(document.querySelector('main#email'));
```

You should have an `#email` selector that sets its elements' `padding` on all sides to `50px`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('#email')?.getPropertyValue('padding'), '50px');
```

You should have an `#email` selector that sets its elements' `margin-top` to `50px`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('#email')?.getPropertyValue('margin-top'), '50px');
```

You should have an `#email` selector that sets its elements' `width` to `500px`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('#email')?.getPropertyValue('width'), '500px');
```

Your `#email` element should have a `2px` border.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('#email')?.getPropertyValue('border-width'), '2px');
```

Your `#email` element should have a `box-sizing` of `border-box`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('#email')?.boxSizing, 'border-box');
```

You should have a `div` element with an `id` of `confidential` within your `#email` element.

```js
assert.exists(document.querySelector('#email > div#confidential'));
```

You should have a `div` element with an `id` of `top-secret` within your `#email` element.

```js
assert.exists(document.querySelector('#email > div#top-secret'));
```

Your `#confidential` element should have its `display` set to `inline-block`.

```js
assert.equal(window.getComputedStyle(document.querySelector('#confidential'))?.display, 'inline-block');
```

Your `#top-secret` element should have its `display` set to `inline-block`.

```js
assert.equal(window.getComputedStyle(document.querySelector('#top-secret'))?.display, 'inline-block');
```

Your `#confidential` element should have a `padding` on all sides.

```js
const style = window.getComputedStyle(document.querySelector('#confidential'));
assert.notEqual(style?.paddingTop, '0px');
assert.notEqual(style?.paddingRight, '0px');
assert.notEqual(style?.paddingBottom, '0px');
assert.notEqual(style?.paddingLeft, '0px');
```

Your `#top-secret` element should have a `padding` on all sides.

```js
const style = window.getComputedStyle(document.querySelector('#top-secret'));
assert.notEqual(style?.paddingTop, '0px');
assert.notEqual(style?.paddingRight, '0px');
assert.notEqual(style?.paddingBottom, '0px');
assert.notEqual(style?.paddingLeft, '0px');
```

Your `#confidential` element should have a left margin.

```js
assert.notEqual(window.getComputedStyle(document.querySelector('#confidential'))?.marginLeft, '0px');
```

Your `#top-secret` element should have a left margin.

```js
assert.notEqual(window.getComputedStyle(document.querySelector('#top-secret'))?.marginLeft, '0px');
```

Your `#confidential` element should have a `border`.

```js
assert.notEqual(window.getComputedStyle(document.querySelector('#confidential'))?.borderWidth, '0px');
```

Your `#top-secret` element should have a `border`.

```js
assert.notEqual(window.getComputedStyle(document.querySelector('#top-secret'))?.borderWidth, '0px');
```

Your `#confidential` element's text should be `CONFIDENTIAL`. You have either omitted the text, or have a typo.

```js
assert.equal(document.querySelector('#confidential').innerText.toLowerCase(), 'confidential' );
```

Your `#top-secret` element's text should be `TOP SECRET`. You have either omitted the text, or have a typo.

```js
assert.equal(document.querySelector('#top-secret').innerText.toLowerCase(), 'top secret' );
```

Your `#confidential` element should use a CSS `transform` to rotate the element.

```js
assert.notEqual(window.getComputedStyle(document.querySelector('#confidential'))?.transform, 'none');
```

Your `#top-secret` element should use a CSS `transform` to rotate the element.

```js
assert.notEqual(window.getComputedStyle(document.querySelector('#top-secret'))?.transform, 'none');
```

You should have at least three paragraph elements within your `#email` element.

```js
assert.isAtLeast(document.querySelectorAll('#email > p').length, 3);
```

You should have at least three `span` elements with a class of `blurred` within your paragraphs.

```js
assert.isAtLeast(document.querySelectorAll('p > span.blurred').length, 3);
```

Your `.blurred` elements should not be empty.

```js
const els = document.querySelectorAll('.blurred');
assert.isAtLeast(els.length, 1);
els.forEach(el => assert.isAtLeast(el.innerText.length , 1))
```

You should have a `.blurred` selector that set its elements `filter` to `blur(3px)`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.blurred')?.filter, 'blur(3px)');
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Confidential Email</title>

</head>

<body>

</body>

</html>
```

```css

```

# --solutions--

```html
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Secret Marshmallow Mission</title>
  <link rel="stylesheet" href="styles.css">
</head>

<body>
  <main id="email">
    <div id="confidential">CONFIDENTIAL</div>
    <p>Dear Agent <span class="blurred">S'more,</span></p>
    <p>We have an emergency. The secret formula for our <span class="blurred">Mega Marshmallow</span> has been
      compromised. This formula is what makes our marshmallows the fluffiest and most delicious.</p>
    <p>We suspect that <span class="blurred">Professor Puff</span> is behind this. He has taken the formula to his
      hidden laboratory. Your mission is to infiltrate the lab and secure the formula before it's too late.</p>
    <p>Be sure to keep the lab's location confidential. Any leak of this information could jeopardize the entire
      operation.</p>
    <div id="top-secret">TOP SECRET</div>
  </main>
</body>

</html>
```

```css
#email {
  background-color: SeaShell;
  margin: 50px auto;
  padding: 50px;
  width: 500px;
  border: 2px solid black;
  box-shadow: 5px 3px 3px gray;
  box-sizing: border-box;
}

#confidential {
  display: inline-block;
  margin-left: 100px;
  padding: 10px;
  text-align: center;
  font-size: 30px;
  transform: rotate(-20deg);
  color: red;
  border: 5px solid red;
  font-weight: bold;
}

#top-secret {
  margin-left: 200px;
  display: inline-block;
  padding: 10px;
  text-align: center;
  font-size: 20px;
  transform: rotate(15deg);
  color: red;
  border: 5px solid red;
  font-weight: bold;
}

.blurred {
  filter: blur(3px);
}
```
