---
id: 6823f9df49cc206af5471a30
title: Debug Camperbot's Profile Page
challengeType: 25
dashedName: lab-debug-camperbots-profile-page
# Purposefully removed the demo type because I don't want any example to show since this is a debugging project.
---

# --description--

Camperbot is trying to build a profile page. They asked a friend to look over their code and they said it has some errors.

Your job is to fix all of Camperbot's errors so they can continue building their profile page. Complete the items in the user stories below and click "Run the Tests" to see if you fixed all the errors.

**User Stories:**

1. Camperbot is trying to use a `heading2` element, but that element does not exist. Fix those tags so it uses a correct second-level heading element.
2. Camperbot is trying to add two paragraphs with `pp`, but those don't exist either. Fix them so they use correct paragraph tags.
3. Camperbot is using an `h3` element for the `Background and Interests` subheading but it has a syntax error. Spot the issue and resolve it.

# --hints--

You should have exactly one `h1` element on the page.

```js
assert.lengthOf(document.querySelectorAll("h1"), 1);
```

You should not remove the `<h1>Hello from Camperbot!</h1>` element from the page.

```js
assert.match(code, /\<h1\s*\>\s*Hello\s*from\s*Camperbot\s*!\s*\<\/h1\s*\>/i);
```

You should have exactly one `h2` element on the page.

```js
assert.lengthOf(document.querySelectorAll("h2"), 1);
```

You should have an `h2` element with the text `About`. Here's an example: `<h2>Text here</h2>`

```js
assert.match(code, /\<h2\s*\>\s*About\s*\<\/h2\s*\>/i);
```

You should have a paragraph element with the text `My name is Camperbot and I love learning new things.` Here's an example: `<p>Text here</p>`

```js
assert.match(code, /\<p\s*\>\s*My\s*name\s*is\s*camperbot\s*and\s*I\s*love\s*learning\s*new\s*things\s*\.\s*\<\/p\s*\>/i);
```

You should have a paragraph element with the text `I enjoy solving puzzles.` Here's an example: `<p>Text here</p>`

```js
assert.match(code, /\<p\s*\>\s*I\s*enjoy\s*solving\s*puzzles\s*\.\s*\<\/p\s*\>/i);
```

You should have exactly two paragraph elements on the page.

```js
assert.lengthOf(document.querySelectorAll("p"), 2);
```

You should have exactly one `h3` element on the page.

```js
assert.lengthOf(document.querySelectorAll("h3"), 1);
```

You should have an `h3` element with the text `Background and Interests`. Here's an example: `<h3>Text here</h3>`

```js
assert.match(code, /\<h3\s*\>\s*Background\s*and\s*Interests\s*\<\/h3\s*\>/i);
```

You should have exactly five total elements on the page.

```js
assert.lengthOf(document.querySelectorAll("body *:not(script)"), 5);
```

# --seed--

## --seed-contents--

```html
<h1>Hello from Camperbot!</h1>

<heading2>About</heading2>

<pp>My name is Camperbot and I love learning new things.</pp>

<h3>Background and Interests<h3/>
<pp>I enjoy solving puzzles.</pp>
```

# --solutions--

```html
<h1>Hello from Camperbot!</h1>

<h2>About</h2>

<p>My name is Camperbot and I love learning new things.</p>

<h3>Background and Interests</h3>
<p>I enjoy solving puzzles.</p>
```
