---
id: 66b205e6eacba4c4e54ea434
title: Build an Email Masker
challengeType: 26
dashedName: build-an-email-masker
---

# --description--

In this lab, you will mask the username part of an email address with asterisks. Masking is a term used to hide or replace sensitive information with asterisks or other characters.

For example, if the email address was `myEmail@email.com`, then the masked email address will be `m*****l@email.com`.

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. Create a function named `maskEmail` that takes `email` as an argument.
2. Inside the function, you should mask the `email` and append the domain name to it.  Remember that you can use methods like `slice`, `repeat`, `indexOf` or even `replace` to help you.
3. Outside the function, declare a variable named `email` to store the email address you want to mask.
4. Call the `maskEmail` function with the `email` variable and output the result to the console. 
5. `maskEmail("apple.pie@example.com")` should return `"a*******e@example.com"`.
6. `maskEmail("freecodecamp@example.com")` should return `"f**********p@example.com"`.
7. `maskEmail("info@test.dev")` should return `"i**o@test.dev"`.
8. `maskEmail("user@domain.org")` should return `"u**r@domain.org"`.

# --hints--

You should define a function named `maskEmail`.

```js
assert.isFunction(maskEmail);
```

The `maskEmail` function should take a string, `email` as an argument.

```js
assert.match(maskEmail.toString(), /\s*maskEmail\(\s*\w+\s*\)/);
```

Outside the function, you should have an `email` variable.

```js
assert.isDefined(email);
```

You should assign a valid email address to your `email` variable.

```js
assert.match(email, /^[a-zA-Z0-9._%-]+\+?[a-zA-Z0-9._%-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/);
```

`maskEmail("apple.pie@example.com")` should return `"a*******e@example.com"`.

```js
assert.strictEqual(maskEmail("apple.pie@example.com"),"a*******e@example.com");
```

`maskEmail("freecodecamp@example.com")` should return `"f**********p@example.com"`.

```js
assert.strictEqual(maskEmail("freecodecamp@example.com"), "f**********p@example.com");
```

`maskEmail("info@test.dev")` should return `"i**o@test.dev"`.

```js
assert.strictEqual(maskEmail("info@test.dev"), "i**o@test.dev");
```

`maskEmail("user@domain.org")` should return `"u**r@domain.org"`.

```js
assert.strictEqual(maskEmail("user@domain.org"), "u**r@domain.org");
```

Your `maskEmail` should produce the correct result.

```js
assert.strictEqual(maskEmail("johnappleseed@email.com"), "j***********d@email.com");
assert.strictEqual(maskEmail("john.doe@example.com"), "j******e@example.com");
assert.strictEqual(maskEmail("jane.smith@sample.org"), "j********h@sample.org");
assert.strictEqual(maskEmail("michael.jordan@testmail.net"), "m************n@testmail.net");
assert.strictEqual(maskEmail("mike+nospam@testmail.net"), "m*********m@testmail.net");
```

You should log the output of calling `maskEmail` with `email` as argument.

```js
assert.match(__helpers.removeJSComments(code), /console\.log\(maskEmail\(email\)\)/);
```

# --seed--

## --seed-contents--

```js

```

# --solutions--

```js
function maskEmail(email) {
  const atIndex = email.indexOf("@");
  const userName = email.slice(0, atIndex);
  const domain = email.slice(atIndex);

  const maskedName =
    userName[0] + "*".repeat(userName.length - 2) + userName[userName.length - 1] + domain;

  return maskedName;
}

const email = "apple.pie@example.com";
console.log(maskEmail(email));
```
