---
id: 66d75dd0aa65a71600dc669b
title: Build an Inventory Management Program
challengeType: 26
dashedName: build-an-inventory-management-program
---

# --description--

In this lab, you will build an inventory management program that will allow you to add, update, find and remove products from the inventory. You will use an array of objects to represent your inventory, where each object will have name and quantity as the keys.

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should declare an empty array named `inventory` that will store product objects having a key `name` with the value of a lowercase string, and a key `quantity` with the value of an integer.
1. You should create a function named `findProductIndex` that takes the product name as its argument and returns the index of the corresponding product object inside the `inventory` array. The function should always use the lowercase form of the product name to perform the search. If the product is not found, the function should return `-1`.
1. You should create a function named `addProduct` that takes a product object as its argument.
1. If the product is already present in the inventory, the `addProduct` function should update its `quantity` value by adding the quantity passed in to the function to the current `quantity` and log to the console the product name followed by a space and `quantity updated`.
1. If the product is not present in the inventory, the `addProduct` function should push the product to the `inventory` array and log the product name to the console, followed by a space and `added to inventory`.
1. You should create a function named `removeProduct` that takes the product name and quantity as its arguments.
1. The `removeProduct` function should subtract the passed quantity from the corresponding product object inside the inventory and log the string `Remaining <product-name> pieces: <product-quantity>` to the console, where `<product-name>` should be replaced by the product name, and `<product-quantity>` should be replaced by the product quantity.
1. If the quantity after the subtraction is zero, `removeProduct` should remove the product object from the inventory. If the quantity in the inventory is not enough to perform the subtraction, the `removeProduct` function should log the string `Not enough <product-name> available, remaining pieces: <product-quantity>` to the console.
1. If the product to remove is not present in the inventory, the `removeProduct` function should log `<product-name> not found` to the console.

**Note:** To prevent conflicts, keep only the logging mentioned in the user stories when running tests.

# --hints--

You should declare an empty array named `inventory`.

```js
assert.match(__helpers.removeJSComments(code), /(let|const|var)\s+inventory\s*=\s*\[\s*\]\s*;?/)
```

You should have a function named `findProductIndex`.

```js
assert.isFunction(findProductIndex)
```

`findProductIndex("flour")` should return the index of the object having `name` equal to `"flour"` inside the `inventory` array.

```js
inventory.length = 0;
inventory.push({name: 'flour', quantity: 15});
inventory.push({name: 'rice', quantity: 10});
inventory.push({name: 'sugar', quantity: 5});
assert.strictEqual(findProductIndex("flour"), 0);
assert.strictEqual(findProductIndex("rice"), 1);
assert.strictEqual(findProductIndex("sugar"), 2);
```

`findProductIndex("FloUr")` should return the index of the object having `name` equal to `"flour"` inside the `inventory` array.

```js
inventory.length = 0;
inventory.push({name: 'flour', quantity: 15});
inventory.push({name: 'rice', quantity: 10});
inventory.push({name: 'sugar', quantity: 5});
assert.strictEqual(findProductIndex("FLour"), 0);
assert.strictEqual(findProductIndex("RICE"), 1);
assert.strictEqual(findProductIndex("suGar"), 2);
```

`findProductIndex("Flour")` should return `-1` when no object having `name` equal to `"flour"` is found inside the `inventory` array.

```js
inventory.length = 0;
inventory.push({name: 'flour', quantity: 15});
inventory.push({name: 'rice', quantity: 10});
inventory.push({name: 'sugar', quantity: 5});
assert.strictEqual(findProductIndex("salt"), -1)
```

You should have a function named `addProduct`.

```js
assert.isFunction(addProduct)
```

`addProduct({name: "FLOUR", quantity: 5})` should add `5` to `quantity` value of the object having `name` equal to `"flour"` in the `inventory` array.

```js
const temp = console.log;
console.log = () => {};
inventory.length = 0;
inventory.push({name: 'flour', quantity: 15});
inventory.push({name: 'rice', quantity: 10});
inventory.push({name: 'sugar', quantity: 5});
addProduct({name: 'Flour', quantity: 5});
addProduct({name: 'RICE', quantity: 5});
addProduct({name: 'SuGar', quantity: 5});
const expected = JSON.stringify([{name: 'flour', quantity: 20}, {name: 'rice', quantity: 15}, {name: 'sugar', quantity: 10}]);
console.log = temp;
assert.equal(JSON.stringify(inventory), expected)
```

`addProduct({name: "FLOUR", quantity: 5})` should log `flour quantity updated` when an object having `name` equal to `"flour"` is found in the `inventory` array.

```js
const logArr = [];
const temp = console.log;
console.log = function(...args) {
    for (const arg of args) {
        logArr.push(arg);
    }
}
inventory.length = 0;
inventory.push({name: 'flour', quantity: 15});
inventory.push({name: 'rice', quantity: 10});
inventory.push({name: 'sugar', quantity: 5});
addProduct({name: 'flOur', quantity: 5});
addProduct({name: 'RICE', quantity: 5});
addProduct({name: 'sugar', quantity: 5});
console.log = temp;
assert.lengthOf(logArr, 3);
assert.strictEqual(logArr[0], "flour quantity updated")
assert.strictEqual(logArr[1], "rice quantity updated")
assert.strictEqual(logArr[2], "sugar quantity updated")
```

`addProduct({name: "FLOUR", quantity: 5})` should push `{name: "flour", quantity: 5}` to the `inventory` array when no object having `name` equal to `"flour"` is found in the inventory.

```js
const temp = console.log;
console.log = () => {};
inventory.length = 0;
inventory.push({name: 'flour', quantity: 15});
inventory.push({name: 'rice', quantity: 10});
inventory.push({name: 'sugar', quantity: 5});
addProduct({name: 'SALT', quantity: 8});
addProduct({name: 'Spam', quantity: 1});
const expected = JSON.stringify([{name: 'flour', quantity: 15}, {name: 'rice', quantity: 10}, {name: 'sugar', quantity: 5}, {name: 'salt', quantity: 8}, {name: 'spam', quantity: 1}]);
console.log = temp;
assert.equal(JSON.stringify(inventory), expected);
```

`addProduct({name: "FLOUR", quantity: 5})` should log `flour added to inventory` when no object having `name` equal to `"flour"` is found in the inventory.

```js
const logArr = [];
const temp = console.log;
console.log = function(...args) {
    for (const arg of args) {
        logArr.push(arg);
    }
}
inventory.length = 0;
inventory.push({name: 'flour', quantity: 15});
inventory.push({name: 'rice', quantity: 10});
inventory.push({name: 'sugar', quantity: 5});
addProduct({name: 'SAlt', quantity: 5});
addProduct({name: 'SPAM', quantity: 1});
console.log = temp;
assert.lengthOf(logArr, 2);
assert.equal(logArr[0], "salt added to inventory");
assert.equal(logArr[1], "spam added to inventory");
```

You should create a function named `removeProduct`.

```js
assert.isFunction(removeProduct);
```

`removeProduct("FLOUR", 5)` should log `flour not found` when no object having `name` equal to `"flour"` is found in the `inventory` array.

```js
const logArr = [];
const temp = console.log;
console.log = function(...args) {
    for (const arg of args) {
        logArr.push(arg);
    }
}
inventory.length = 0;
inventory.push({name: 'flour', quantity: 15});
inventory.push({name: 'rice', quantity: 10});
inventory.push({name: 'sugar', quantity: 5});
removeProduct("SALT", 2);
removeProduct("Spam", 1);
console.log = temp;
assert.lengthOf(logArr, 2);
assert.equal(logArr[0], "salt not found");
assert.equal(logArr[1], "spam not found");
```

`removeProduct("FLOUR", 5)` should subtract `5` from the `quantity` value of the object having `name` equal to `"flour"` inside the `inventory` array.

```js
const temp = console.log;
console.log = () => {};
inventory.length = 0;
inventory.push({name: 'flour', quantity: 15});
inventory.push({name: 'rice', quantity: 10});
inventory.push({name: 'sugar', quantity: 5});
removeProduct("flour", 10);
removeProduct("RICE", 5);
removeProduct("Sugar", 2);
const expected = JSON.stringify([{name: 'flour', quantity: 5}, {name: 'rice', quantity: 5}, {name: 'sugar', quantity: 3}]);
console.log = temp;
assert.equal(JSON.stringify(inventory), expected)
```

`removeProduct("FLOUR", 5)` should log `Remaining flour pieces: 15` to the console, when `inventory` is equal to `[{name: "flour", quantity: 20}, {name: "rice", quantity: 5}]`.

```js
const logArr = [];
const temp = console.log;
console.log = function(...args) {
    for (const arg of args) {
        logArr.push(arg);
    }
}
inventory.length = 0;
inventory.push({name: 'flour', quantity: 15});
inventory.push({name: 'rice', quantity: 10});
inventory.push({name: 'sugar', quantity: 5});
removeProduct("Flour", 5);
removeProduct("RICE", 5);
removeProduct("Sugar", 2);
console.log = temp;
assert.lengthOf(logArr, 3);
assert.equal(logArr[0], "Remaining flour pieces: 10");
assert.equal(logArr[1], "Remaining rice pieces: 5");
assert.equal(logArr[2], "Remaining sugar pieces: 3");
```

If the `quantity` after the subtraction is zero, `removeProduct` should remove the product object from the inventory.

```js
const temp = console.log;
console.log = () => {};
inventory.length = 0;
inventory.push({name: 'flour', quantity: 15});
inventory.push({name: 'rice', quantity: 10});
inventory.push({name: 'sugar', quantity: 5});
removeProduct("flour", 15);
removeProduct("rice", 10);
const expected = JSON.stringify([{name: 'sugar', quantity: 5}]);
console.log = temp;
assert.equal(JSON.stringify(inventory), expected)
```

`removeProduct("FLOUR", 10)` should log `Not enough flour available, remaining pieces: 5` when `inventory` is equal to `[{name: "flour", quantity: 5}, {name: "rice", quantity: 5}]`.

```js
const logArr = [];
const temp = console.log;
console.log = function(...args) {
    for (const arg of args) {
        logArr.push(arg);
    }
}
inventory.length = 0;
inventory.push({name: 'flour', quantity: 15});
inventory.push({name: 'rice', quantity: 10});
inventory.push({name: 'sugar', quantity: 5});
removeProduct("flour", 20);
removeProduct("RICE", 20);
removeProduct("Sugar", 20);
console.log = temp;
assert.lengthOf(logArr, 3);
assert.equal(logArr[0], "Not enough flour available, remaining pieces: 15")
assert.equal(logArr[1], "Not enough rice available, remaining pieces: 10")
assert.equal(logArr[2], "Not enough sugar available, remaining pieces: 5")
```

# --seed--

## --seed-contents--

```js

```

# --solutions--

```js
const inventory = [];

const findProductIndex = (productName) => {
    let productIndex = -1;
    inventory.forEach((element, index) => {
        if (element.name === productName.toLowerCase()) {
            productIndex = index;
        }
    })
    return productIndex;
}

const addProduct = (product) => {
    product.name = product.name.toLowerCase();
    const productIndex = findProductIndex(product.name);
    if (productIndex < 0) {
        inventory.push(product);
        console.log(`${product.name} added to inventory`)
        return;
    }
    inventory[productIndex].quantity += product.quantity;
    console.log(`${product.name} quantity updated`)
}

const removeProduct = (productName, productQuantity) => {
    productName = productName.toLowerCase();
    const productIndex = findProductIndex(productName);
    if (productIndex < 0) {
        console.log(`${productName} not found`);
        return;
    }
    const foundProduct = inventory[productIndex];
    if (foundProduct.quantity >= productQuantity) {
        foundProduct.quantity -= productQuantity;
        console.log(`Remaining ${productName} pieces: ${foundProduct.quantity}`)
        if (!foundProduct.quantity) {
            inventory.splice(productIndex, 1);
        }
        return;
    }
    console.log(`Not enough ${productName} available, remaining pieces: ${foundProduct.quantity}`);
}

// Example usage

const product1 = {
    name: 'flour',
    quantity: 15
}
const product2 = {
    name: 'flour',
    quantity: 10
}
const product3 = {
    name: 'sugar',
    quantity: 20
}
const product4 = {
    name: 'salt',
    quantity: 12
}

addProduct(product1);
addProduct(product2);
addProduct(product3);
addProduct(product4);
removeProduct('flour', 30);
removeProduct('flour', 20);
removeProduct('flour', 5);
```
