---
id: 66faac4139dbbd5dd632c860
title: Build a Job Application Form
challengeType: 25
dashedName: lab-job-application-form
demoType: onClick
---

# --description--

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab. 

**User Stories:**

1. You should have a `div` element with the class `container`.
1. Inside the `div` element, you should have a `form` element.
1. The form should contain an `input` element with the type `text` and the id `name` for entering the user's full name.
1. You should have another `input` element with the type `email` and the id `email` for entering the user's email address.
1. The form should include a `select` element with the id `position` that allows users to select a job position.
1. You should have a `fieldset` element with class of `radio-group`.
1. Inside `.radio-group` you should have a set of `input` elements with the type `radio` and relevant labels for selecting availability options (e.g., Full-Time, Part-Time). The group `name` should be `availability`.
1. You should have a `textarea` element with the id `message` for entering a message.
1. You should associate every `input` element with a `label` element. 
1. You should have a `button` element with the type `submit` for submitting the form.
1. Add a `:focus` pseudo-class to the `input` and `textarea` elements to change their border color when focused.
1. The `input`, `select` and `textarea` elements should have an `:invalid` pseudo-class that changes the border color to red when invalid input is detected.
1. The `input`, `select` and `textarea` elements should have a `:valid` pseudo-class that changes the border color to green when valid input is entered.
1. The `button` element should have a `:hover` pseudo-class that changes the background color when hovered over.
1. Use the `:checked` pseudo-class on `.radio-group input[type="radio"]` to add a border color, background color and a box shadow when the radio button is selected.
1. Use the `:checked` pseudo-class on radio buttons to change the text color of the associated `label` when the option is selected.
1. Add a `:first-of-type` pseudo-class to the `input` element to style the first input field differently. (e.g., rounded corners).

**Note:** Be sure to link your stylesheet in your HTML and apply your CSS.

# --hints--

You should have a `div` element with the class `container`.

```js
assert.exists(document.querySelector("div.container"));
```

Inside the `div` element, you should have a `form` element.

```js
assert.exists(document.querySelector("div.container > form"));
```

The form should contain an `input` element with the type `text` and the id `name` for entering the user's full name.

```js
assert.exists(document.querySelector("div.container > form input#name[type='text']"));
```

You should have another `input` element with the type `email` and the id `email` for entering the user's email address.

```js
assert.exists(document.querySelector("div.container > form input#email[type='email']"));
```

The form should include a `select` element with the id `position` with some `option` elements.

```js
assert.exists(document.querySelector("div.container > form select#position"));
assert.isNotEmpty(document.querySelectorAll("div.container > form select#position > option"))
```

You should have a `fieldset` or `section` element with the class `.radio-group`.

```js
assert.lengthOf(document.querySelectorAll('form fieldset.radio-group, form section.radio-group'), 1)
```

Inside `.radio-group` you should have a group of `input` elements with the type `radio` for selecting availability options. The group `name` should be `availability`.

```js
assert.isAtLeast(document.querySelectorAll("div.container > form .radio-group input[type='radio'][name='availability']").length, 2);
assert.isEmpty(document.querySelectorAll("div.container > form .radio-group input[type='radio']:not([name='availability'])"))
```

You should have a `textarea` element with the id `message` for entering a message.

```js
assert.isNotEmpty(document.querySelectorAll("div.container > form textarea#message"));
```

You should associate every `input` element with a `label` element. 

```js
const els = document.querySelectorAll('input');
assert.isNotEmpty(els);
els.forEach(input => {
  const label = document.querySelector(`label[for="${input.id}"]`) || input.parentElement;
  assert.exists(label); 
  assert.equal(label.tagName, "LABEL");
})
```

You should have a `button` element with the type `submit` for submitting the form.

```js
assert.isNotEmpty(document.querySelectorAll("div.container > form button[type='submit']"));
```

You should add a `:focus` pseudo-class to the `input` and `textarea` elements to change their border color when focused. Use a list selector in the given order.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle('input:focus, textarea:focus').getPropertyValue('border-color'))
```

The `input`, `select` and `textarea` elements should have an `:invalid` pseudo-class that changes the border color to red when invalid input is detected. Use a list selector in the given order.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('input:invalid, select:invalid, textarea:invalid').getPropertyValue('border-color'), 'red')
```

The `input`, `select` and `textarea` elements should have a `:valid` pseudo-class that changes the border color to green when valid input is entered. Use a list selector in the given order.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('input:valid, select:valid, textarea:valid').getPropertyValue('border-color'), 'green')
```

The `button` element should have a `:hover` pseudo-class that changes the background color when hovered over.

```js
assert.isNotEmpty(new __helpers.CSSHelp(document).getStyle('button:hover').getPropertyValue('background-color'))
```

You should use the `:checked` pseudo-class on `.radio-group input[type="radio"]` to add a border color when the radio button is selected.

```js
const style = new __helpers.CSSHelp(document).getStyle('.radio-group input[type="radio"]:checked');
assert.isNotEmpty(style.getPropertyValue('border-color'));
```

You should use the `:checked` pseudo-class on `.radio-group input[type="radio"]` to add a background color when the radio button is selected.

```js
const style = new __helpers.CSSHelp(document).getStyle('.radio-group input[type="radio"]:checked');
assert.isNotEmpty(style.getPropertyValue('background-color'));
```

You should use the `:checked` pseudo-class on `.radio-group input[type="radio"]` to add a box shadow when the radio button is selected.

```js
const style = new __helpers.CSSHelp(document).getStyle('.radio-group input[type="radio"]:checked');
assert.isNotEmpty(style.getPropertyValue('box-shadow'));
```

You should use the `:checked` pseudo-class on radio buttons to change the text color of the associated `label` when the option is selected.

```js
const els = document.querySelectorAll('input[type="radio"]');
assert.isNotEmpty(els);
els.forEach(input => {
  const label = document.querySelector(`label[for="${input.id}"]`) || input.parentElement;
  assert.equal(label.tagName, "LABEL");
  input.checked = false;
  const colorBefore = getComputedStyle(label).color;
  input.checked = true;
  const colorAfter = getComputedStyle(label).color;
  assert.notEqual(colorAfter, colorBefore);
})
```

Add a `:first-of-type` pseudo-class to the `input` elements to style the first input field differently.

```js
const pseudo = new __helpers.CSSHelp(document).getStyle('input:first-of-type');
assert.exists(pseudo);
assert.isNotEmpty([...pseudo]);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Job Application Form</title>
</head>
<body>

</body>
</html>
```

```css

```

# --solutions--

```html
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Job Application</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <div class="container">
        <h1>Job Application Form</h1>
        <form id="job-application">
            <label for="name">Full Name:</label>
            <input type="text" id="name" name="name" placeholder="Enter your name" required>

            <label for="email">Email:</label>
            <input type="email" id="email" name="email" placeholder="Enter your email" required>

            <label for="position">Position:</label>
            <select id="position" name="position" required>
                <option value="">Select a position</option>
                <option value="developer">Developer</option>
                <option value="designer">Designer</option>
                <option value="manager">Manager</option>
            </select>

            <fieldset class="radio-group">
              <legend>Availability:</legend>
                <input type="radio" id="fullTime" name="availability" value="fullTime" checked>
                <label for="fullTime">Full-Time</label>
                <input type="radio" id="partTime" name="availability" value="partTime">
                <label for="partTime">Part-Time</label>
            </fieldset>

            <label for="message">Why do you want this job?</label>
            <textarea id="message" name="message" rows="5" placeholder="Write your motivation" required></textarea>

            <button type="submit">Submit Application</button>
        </form>
    </div>
</body>
</html>
```

```css
body {
  font-family: Arial, sans-serif;
  background-color: white;
  padding: 20px;
}

.container {
  max-width: 600px;
  margin: 0 auto;
  background-color: white;
  padding: 20px;
  border-radius: 8px;
  box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
}

h1 {
  text-align: center;
}

label {
  display: block;
  margin-bottom: 5px;
  font-weight: bold;
}

input, select, textarea {
  width: 100%;
  padding: 10px;
  margin-bottom: 15px;
  border: 1px solid #ccc;
  border-radius: 4px;
  box-sizing: border-box;
}

.radio-group {
  display: flex;
  align-items: center;
  margin-top: 15px;
}
.radio-group input[type="radio"] {
  margin-right: 10px;
  -webkit-appearance: none;
  -moz-appearance: none;
  appearance: none;
  width: 20px;
  height: 20px;
  border: 2px solid #ccc;
  border-radius: 50%;
  outline: none;
  transition: border-color 0.2s;
}

.radio-group label {
  margin: 0;
  font-weight: normal;
  cursor: pointer;
}

button {
  width: 100%;
  padding: 10px;
  background-color: green;
  border: none;
  color: white;
  border-radius: 4px;
  font-size: 16px;
  cursor: pointer;
}

input:focus, textarea:focus {
  border-color: blue;
  outline: none;
}

input:invalid, select:invalid, textarea:invalid {
  border-color: red;
}

input:valid, select:valid, textarea:valid {
  border-color: green;
}

.radio-group input[type="radio"]:checked {
  border-color: green;
  background-color: green;
  box-shadow: inset 0 0 0 4px white;
}

button:hover {
  background-color: black;
}

input[type="radio"]:checked + label {
  color: green;
}

button:disabled {
  background-color: grey;
}

input:first-of-type {
  border-top-left-radius: 4px;
  border-top-right-radius: 4px;
}

textarea:nth-child(5) {
  border-bottom-left-radius: 4px;
  border-bottom-right-radius: 4px;
}
```
