---
id: 66db529d37ad966480ebb633
title: Build a Lunch Picker Program
challengeType: 26
dashedName: build-a-lunch-picker-program
---

# --description--

In this lab, you'll build a program that helps in managing lunch options. You'll work with an array of lunches, add and remove items from the array, and randomly select a lunch option.

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should create a `lunches` variable and assign it an empty array that will be used to store lunch items.

2. You should create a function `addLunchToEnd` that takes an array as the first argument and a string as the second argument. The function should:
    - Add the string to the end of the array.
    - Log the string `[Lunch Item] added to the end of the lunch menu.` to the console, where `[Lunch Item]` is the string passed to the function.
    - Return the updated array.

3. You should create a function `addLunchToStart` that takes an array as the first argument and a string as the second argument. The function should:
    - Add the string to the start of the array.
    - Log the string `[Lunch Item] added to the start of the lunch menu.` to the console, where `[Lunch Item]` is the string passed to the function.
    - Return the updated array.

4. You should create a function `removeLastLunch` that takes an array as its argument. The function should:
   - Remove the last element from the array.
   - If  the removal is successful, log the string `[Lunch Item] removed from the end of the lunch menu.` to the console, where `[Lunch Item]` is the element removed from the array.
   - If the array is empty, log the string `"No lunches to remove."` to the console.
   - Return the updated array.

5. You should create a function `removeFirstLunch` that takes an array as its argument. The function should:
   - Remove the first element from the array.
   - If the removal is successful, log the string `[Lunch Item] removed from the start of the lunch menu.` to the console, where `[Lunch Item]` is the element removed from the array.
   - If the array is empty, log the string `"No lunches to remove."` to the console.
   - Return the updated array.

6. You should create a function `getRandomLunch` that takes an array as its argument. The function should:
   - Select a random element from the array.
   - If successful, log the string `Randomly selected lunch: [Lunch Item]` to the console, where `[Lunch Item]` is a random element in the array.
   - If the array is empty, log the string `"No lunches available."` to the console.

7. You should create a function `showLunchMenu` that takes an array as its argument and:
   - If there are elements in the array, logs the string `Menu items: [Lunch Item], [Lunch Item]...` to the console, where each `[Lunch item]` is one of the elements in the array, in order.
   - If the array is empty, logs the string `"The menu is empty."` to the console.

# --hints--

You should declare a variable `lunches` and assign it an empty array to store the lunch items.

```js
assert.isArray(lunches);
```

You should define a function `addLunchToEnd`.

```js
assert.isFunction(addLunchToEnd);
```

The function `addLunchToEnd` should have two parameters.

```js
assert.lengthOf(addLunchToEnd, 2);
```

`addLunchToEnd(lunches, "Tacos")` should log the string `"Tacos added to the end of the lunch menu."` to the console.

```js
const tempArr = [];
const temp = console.log;
const testLunches = []
try {
  console.log = obj => tempArr.push(obj);
  addLunchToEnd(testLunches, "Tacos");
  assert.strictEqual(tempArr[0], "Tacos added to the end of the lunch menu.");
  addLunchToEnd(testLunches, "Pizza");
  assert.strictEqual(tempArr[1], "Pizza added to the end of the lunch menu.");
} finally {
  console.log = temp;
}
```

`addLunchToEnd(["Pizza", "Tacos"], "Burger")` should return `["Pizza", "Tacos", "Burger"]`.

```js
const temp = console.log;
console.log = () => {}
try {
  assert.deepStrictEqual(addLunchToEnd(["Pizza", "Tacos"], "Burger"), ["Pizza", "Tacos", "Burger"]);
  assert.deepStrictEqual(addLunchToEnd(["Fries"], "Tacos"), ["Fries", "Tacos"]);
} finally {
  console.log = temp;
}
```

You should define a function `addLunchToStart`.

```js
assert.isFunction(addLunchToStart);
```

The function `addLunchToStart` should have two parameters.

```js
assert.lengthOf(addLunchToStart, 2);
```

`addLunchToStart(lunches, "Sushi")` should log the string `"Sushi added to the start of the lunch menu."` to the console.

```js
const tempArr = [];
const testLunches = [];
const temp = console.log;
try {
  console.log = obj => tempArr.push(obj);
  addLunchToStart(testLunches, "Sushi");
  assert.strictEqual(tempArr[0], "Sushi added to the start of the lunch menu.");  
  addLunchToStart(testLunches, "Burger");
  assert.strictEqual(tempArr[1], "Burger added to the start of the lunch menu.");
} finally {
  console.log = temp;
}
```

`addLunchToStart(["Burger", "Sushi"], "Pizza")` should return `["Pizza", "Burger", "Sushi"]`.

```js
const temp = console.log;
console.log = () => {}
try {
  assert.deepStrictEqual(addLunchToStart(["Burger", "Sushi"], "Pizza"), ["Pizza", "Burger", "Sushi"]);
  assert.deepStrictEqual(addLunchToStart(["Noodles"], "Sushi"), ["Sushi", "Noodles"]);
} finally {
  console.log = temp;
}
```

You should define a function `removeLastLunch`.

```js
assert.isFunction(removeLastLunch)
```

The function `removeLastLunch` should have one parameter.

```js
assert.lengthOf(removeLastLunch, 1);
```

When the input array is empty, the function `removeLastLunch` should log the string `"No lunches to remove."` to the console.

```js
const testLunches = [];
const tempArr = [];
const temp = console.log;
try {
  console.log = obj => tempArr.push(obj);
  removeLastLunch(testLunches);
  assert.strictEqual(tempArr[0], "No lunches to remove.");
} finally {
  console.log = temp;
}
```

`removeLastLunch(["Stew", "Soup", "Toast"])` should log the string `"Toast removed from the end of the lunch menu."` to the console.

```js
let testLunches = ["Stew", "Soup", "Toast"];
const tempArr = [];
const temp = console.log;
try {
  console.log = obj => tempArr.push(obj);
  removeLastLunch(testLunches);
  assert.strictEqual(tempArr[0], "Toast removed from the end of the lunch menu.");
  testLunches = ["Rice", "Pizza"];
  removeLastLunch(testLunches);
  assert.strictEqual(tempArr[1], "Pizza removed from the end of the lunch menu.");
} finally {
  console.log = temp;
}
```

`removeLastLunch(["Sushi", "Pizza", "Noodles"])` should return `["Sushi", "Pizza"]`.

```js
const temp = console.log;
console.log = () => {}
try {
  assert.deepStrictEqual(removeLastLunch(["Sushi", "Pizza", "Noodles"]), ["Sushi", "Pizza"]);
  assert.deepStrictEqual(removeLastLunch(["Pizza", "Burger"]), ["Pizza"]);
} finally {
  console.log = temp;
}
```

You should define a function `removeFirstLunch`.

```js
assert.isFunction(removeFirstLunch);
```

The function `removeFirstLunch` should have a single parameter.

```js
assert.lengthOf(removeFirstLunch, 1);
```

When the input array is empty, the function `removeFirstLunch` should log the string `"No lunches to remove."` to the console.

```js
const testLunches = [];
const tempArr = [];
const temp = console.log;
try {
  console.log = obj => tempArr.push(obj);
  removeFirstLunch(testLunches);
  assert.strictEqual(tempArr[0], "No lunches to remove.");
} finally {
  console.log = temp;
}
```

`removeFirstLunch(["Salad", "Eggs", "Cheese"])` should log the string `"Salad removed from the start of the lunch menu."` to the console.

```js
let testLunches = ["Salad", "Eggs", "Cheese"];
const tempArr = [];
const temp = console.log;
try {
  console.log = obj => tempArr.push(obj);
  removeFirstLunch(testLunches);
  assert.strictEqual(tempArr[0], "Salad removed from the start of the lunch menu.");
  testLunches = ["Stew", "Soup", "Toast"]
  removeFirstLunch(testLunches);
  assert.strictEqual(tempArr[1], "Stew removed from the start of the lunch menu.");
} finally {
  console.log = temp;
}
```

`removeFirstLunch(["Sushi", "Pizza", "Burger"])` should return `["Pizza", "Burger"]`.

```js
const temp = console.log;
console.log = () => {}
try {
  assert.deepStrictEqual(removeFirstLunch(["Sushi", "Pizza", "Burger"]), ["Pizza", "Burger"]);
  assert.deepStrictEqual(removeFirstLunch(["Pizza", "Burger"]), ["Burger"]);
} finally {
  console.log = temp;
}
```

`addLunchToEnd`, `addLunchToStart`, `removeLastLunch`, and `removeFirstLunch` should return the same array passed as an argument after updating it.

```js
const temp = console.log;
console.log = () => {}
const testLunches = ["Spam"];
try {
  assert.equal(addLunchToEnd(testLunches, "Pizza"), testLunches);
  assert.equal(addLunchToStart(testLunches, "Caviar"), testLunches);
  assert.equal(removeLastLunch(testLunches), testLunches);
  assert.equal(removeFirstLunch(testLunches), testLunches);
} finally {
  console.log = temp;
}
```

You should define a function `getRandomLunch`.

```js
assert.isFunction(getRandomLunch);
```

The function `getRandomLunch` should have a single parameter.

```js
assert.lengthOf(getRandomLunch, 1);
```

When the input array is empty, the function `getRandomLunch` should log the string `"No lunches available."` to the console.

```js
const testLunches = [];
const tempArr = [];
const temp = console.log;
try {
  console.log = obj => tempArr.push(obj);
  getRandomLunch(testLunches);
  assert.strictEqual(tempArr[0], "No lunches available.");
} finally {
  console.log = temp;
}
```

When the input array is not empty, the function `getRandomLunch` should log a string in the format `Randomly selected lunch: [Lunch Item]` to the console.

```js
const testLunches = ["Fish", "Fries", "Roast"];
const tempRandom = Math.random;
const tempArr = [];
const temp = console.log;

try {
  console.log = obj => tempArr.push(obj);
  // check that it correctly outputs the first item
  Math.random = () => 0;
  getRandomLunch([...testLunches]);
  assert.strictEqual(tempArr[0], `Randomly selected lunch: ${testLunches[0]}`);

  // Second item
  Math.random = () => 0.4;
  getRandomLunch([...testLunches]);
  assert.strictEqual(tempArr[1], `Randomly selected lunch: ${testLunches[1]}`);

  // Third item
  Math.random = () => 0.8;
  getRandomLunch([...testLunches]);
  assert.strictEqual(tempArr[2], `Randomly selected lunch: ${testLunches[2]}`);

} finally {
  Math.random = tempRandom;
  console.log = temp;
}
```

The `getRandomLunch` function should not change the array passed to it as argument.

```js
const testLunches = ["Fish", "Fries", "Roast"];
let originalLunches = [...testLunches];
const tempRandom = Math.random;

try {
  Math.random = () => 0;
  getRandomLunch(testLunches);
  assert.sameOrderedMembers(testLunches, originalLunches);

  Math.random = () => 0.4;
  getRandomLunch(testLunches);
  assert.sameOrderedMembers(testLunches, originalLunches);

  Math.random = () => 0.8;
  getRandomLunch(testLunches);
  assert.sameOrderedMembers(testLunches, originalLunches);

  const emptyLunches = [];
  let originalEmpty = [...emptyLunches];
  getRandomLunch(emptyLunches);
  assert.sameOrderedMembers(emptyLunches, originalEmpty);

} finally {
  Math.random = tempRandom;
}
```

You should define a function `showLunchMenu`.

```js
assert.isFunction(showLunchMenu);
```

The function `showLunchMenu` should have a single parameter.

```js
assert.lengthOf(showLunchMenu, 1);
```

When the input array is empty, the function `showLunchMenu` should log the string `"The menu is empty."` to the console.

```js
const testLunches = [];
const tempArr = [];
const temp = console.log;
try {
  console.log = obj => tempArr.push(obj);
  showLunchMenu(testLunches);
  assert.strictEqual(tempArr[0], "The menu is empty.");
} finally {
  console.log = temp;
}
```

`showLunchMenu(["Greens", "Corns", "Beans"])` should log `"Menu items: Greens, Corns, Beans"` to the console.

```js
const testLunches = ["Greens", "Corns", "Beans"];
const tempArr = [];
const temp = console.log;
try {
  console.log = obj => tempArr.push(obj);
  showLunchMenu(testLunches);
  assert.strictEqual(tempArr[0], `Menu items: ${testLunches.join(", ")}`);
} finally {
  console.log = temp;
}
```

`showLunchMenu(["Pizza", "Burger", "Fries", "Salad"])` should log `"Menu items: Pizza, Burger, Fries, Salad"` to the console.

```js
const testLunches = ["Pizza", "Burger", "Fries", "Salad"];
const tempArr = [];
const temp = console.log;
try {
  console.log = obj => tempArr.push(obj);
  showLunchMenu(testLunches);
  assert.strictEqual(tempArr[0], `Menu items: ${testLunches.join(", ")}`);
} finally {
  console.log = temp;
}
```

# --seed--

## --seed-contents--

```js

```

# --solutions--

```js
const lunches = [];

// Add a new lunch to the end of the list
function addLunchToEnd(lunches, newLunch) {
  lunches.push(newLunch);
  console.log(`${newLunch} added to the end of the lunch menu.`);
  return lunches;
}

// Add a new lunch to the start of the list
function addLunchToStart(lunches, newLunch) {
  lunches.unshift(newLunch);
  console.log(`${newLunch} added to the start of the lunch menu.`);
  return lunches;
}

// Remove the last lunch from the list
function removeLastLunch(lunches) {
  const removedLunch = lunches.pop();
  if (removedLunch) {
    console.log(`${removedLunch} removed from the end of the lunch menu.`);
  } else {
    console.log("No lunches to remove.");
  }
  return lunches;
}

// Remove the first lunch from the list
function removeFirstLunch(lunches) {
  const removedLunch = lunches.shift();
  if (removedLunch) {
    console.log(`${removedLunch} removed from the start of the lunch menu.`);
  } else {
    console.log("No lunches to remove.");
  }
  return lunches;
}

// Function to get a random lunch from the list
function getRandomLunch(lunches) {
  if (lunches.length === 0) {
    console.log("No lunches available.");
  }
  else {
    const randomIndex = Math.floor(Math.random() * lunches.length);
    const randomLunch = lunches[randomIndex];
    console.log(`Randomly selected lunch: ${randomLunch}`);
  }
}

// Function to display all the lunches in the list
function showLunchMenu(lunches) {
  if (lunches.length === 0) {
    console.log("The menu is empty.");
  }
  else {
    console.log(`Menu items: ${lunches.join(', ')}`);
  }
}

addLunchToEnd(lunches, "Tacos");
addLunchToStart(lunches, "Sushi");
removeLastLunch(lunches);
removeFirstLunch(lunches);
getRandomLunch(lunches);
showLunchMenu(lunches);

```
