---
id: 66ba762af611169359d9d369
title: Build a Newspaper Article
challengeType: 25
dashedName: build-a-newspaper-article
demoType: onClick
---

# --description--

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should set the root `font-size` of your HTML document to `24px`.
1. You should have an element with a class of `newspaper` that contains all your other elements.
1. Your `.newspaper` element should have a `font-size` of `16px` and a font of `Open Sans` with a fallback font of `sans-serif`.
1. Within your `.newspaper` element, you should have at least seven more elements: one for the newspaper name that has a class of `name`, one for the date of the article with a class of `date`, one for the headline with a class of `headline`, one for the sub-headline with a class of `sub-headline`, one for the author with a class of `author`, and two paragraphs each with a class of `text`. All of these elements should be filled with your article information.
1. Your `.name` element should have a `font-size` that is twice the root element's `font-size` and should use the `Times New Roman` font, with a fallback font of `serif`.
1. Your `.name` and `.author` elements should use CSS to make all their characters uppercase.
1. Your `.headline` element should have a `font-size` that is twice its parent element's `font-size` and should be bold.
1. Your `.sub-headline` element should have a `font-weight` of `100`, a `font-size` that is `1.5` times its parent element's `font-size`, and should be italicized.
1. Your `.author` should use CSS to make it bold.
1. Your `.text` elements should have a `text-indent` of `20px`.
1. Your `.text` elements should have a `line-height` that is twice their parent element's `font-size`.
1. The first letter of your `.text` elements should be bold and twice the size of their parent element's `font-size`. Use the `::first-letter` selector for this.

# --hints--

You should have an `html` selector that sets its `font-size` to `24px`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('html')?.fontSize, '24px');
```

You should have an element with a class of `newspaper`.

```js
assert.exists(document.querySelector('.newspaper'));
```

You should have a `.newspaper` selector that sets its elements' `font-size` to `16px`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.newspaper')?.fontSize, '16px');
```

You should have a `.newspaper` selector that sets its elements' `font-family` to `'Open Sans', sans-serif`.

```js
assert.oneOf(new __helpers.CSSHelp(document).getStyle('.newspaper')?.fontFamily, ['"Open Sans", sans-serif', 'Open Sans, sans-serif']);
```

You should have an element with a class of `name` within your `.newspaper` element.

```js
assert.exists(document.querySelector('.newspaper > .name'));
```

Your `.name` element should have the name of your newspaper.

```js
assert.isAtLeast(document.querySelector('.newspaper > .name')?.innerText.length, 1);
```

You should have an element with a class of `date` within your `.newspaper` element.

```js
assert.exists(document.querySelector('.newspaper > .date'));
```

Your `.date` element should have the date.

```js
assert.isAtLeast(document.querySelector('.newspaper > .date')?.innerText.length, 1);
```

You should have an element with a class of `headline` within your `.newspaper` element.

```js
assert.exists(document.querySelector('.newspaper > .headline'));
```

Your `.headline` element should have your article headline.

```js
assert.isAtLeast(document.querySelector('.newspaper > .headline')?.innerText.length, 1);
```

You should have an element with a class of `sub-headline` within your `.newspaper` element.

```js
assert.exists(document.querySelector('.newspaper > .sub-headline'));
```

Your `.sub-headline` element should have your article sub-headline.

```js
assert.isAtLeast(document.querySelector('.newspaper > .sub-headline')?.innerText.length, 1);
```

You should have an element with a class of `author` within your `.newspaper` element.

```js
assert.isAtLeast(document.querySelectorAll('.newspaper > .author').length, 1);
```

Your `.author` element should have your article author.

```js
assert.isAtLeast(document.querySelector('.newspaper > .author')?.innerText.length, 1);
```

You should have at least two paragraph elements, each with a class of `text`, within your `.newspaper` element.

```js
assert.isAtLeast(document.querySelectorAll('.newspaper > .text').length, 2);
```

Your `.text` elements should have your article text.

```js
const textEls = document.querySelectorAll('.newspaper > .text');
assert.isAtLeast(textEls.length, 1);
textEls.forEach(el => assert.isAtLeast(el.innerText.length, 1))
```

You should have a `.name` selector that sets its elements' `font-size` to `2rem`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.name')?.fontSize, '2rem');
```

You should have a `.name` selector that sets its elements' `font-family` to `'Times New Roman', serif`.

```js
assert.oneOf(new __helpers.CSSHelp(document).getStyle('.name')?.fontFamily, ['"Times New Roman", serif', 'Times New Roman, serif']);
```

The `.name` element should have the `text-transform` property set to `uppercase`.

```js
const condition1 = new __helpers.CSSHelp(document).getStyle('.name')?.textTransform === 'uppercase';
const condition2 = new __helpers.CSSHelp(document).getStyle('.author, .name')?.textTransform === 'uppercase';
const condition3 = new __helpers.CSSHelp(document).getStyle('.name, .author')?.textTransform === 'uppercase';
assert.isTrue(condition1 || condition2 || condition3);
```

The `.author` element should have the `text-transform` property set to `uppercase`.

```js
const condition1 = new __helpers.CSSHelp(document).getStyle('.author')?.textTransform === 'uppercase';
const condition2 = new __helpers.CSSHelp(document).getStyle('.author, .name')?.textTransform === 'uppercase';
const condition3 = new __helpers.CSSHelp(document).getStyle('.name, .author')?.textTransform === 'uppercase';
assert.isTrue(condition1 || condition2 || condition3);
```

You should have a `.headline` selector that sets its elements' `font-size` to `2em`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.headline')?.fontSize, '2em');
```

You should have a `.headline` selector that sets its elements' `font-weight` to `bold`.

```js
assert.oneOf(new __helpers.CSSHelp(document).getStyle('.headline')?.fontWeight, ['bold', '700']);
```

You should have a `.sub-headline` selector that sets its elements' `font-weight` to `100`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.sub-headline')?.fontWeight, '100');
```

You should have a `.sub-headline` selector that sets its elements' `font-size` to `1.5em`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.sub-headline')?.fontSize, '1.5em');
```

You should have a `.sub-headline` selector that sets its elements' `font-style` to `italic`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.sub-headline')?.fontStyle, 'italic');
```

You should have an `.author` selector that sets its elements' `font-weight` to `bold`.

```js
assert.oneOf(new __helpers.CSSHelp(document).getStyle('.author')?.fontWeight, ['bold', '700']);
```

You should have a `.text` selector that sets its elements' `text-indent` to `20px`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.text')?.textIndent, '20px');
```

You should have a `.text` selector that sets its elements' `line-height` to `2em`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.text')?.lineHeight, '2em');
```

You should have a `.text::first-letter` selector that sets its elements' `font-weight` to `bold`.

```js
assert.oneOf(new __helpers.CSSHelp(document).getStyle('.text::first-letter')?.fontWeight, ['bold', '700']);
```

You should have an `.text::first-letter` selector that sets its elements' `font-size` to `2em`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.text::first-letter')?.fontSize, '2em');
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Newspaper Article</title>
  </head>
  <body>

  </body>
</html>
```

```css

```

# --solutions--

```html
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Daily Chuckles</title>
  <link rel="stylesheet" href="styles.css">
</head>

<body>
  <main class="newspaper">
    <h1 class="name">Daily Chuckles</h1>
    <p class="date">July 5, 2024</p>
    <h2 class="headline">Breaking: Grandma Edna Saves Earth</h2>
    <h3 class="sub-headline">Alien Invasion Foiled by Tech-Savvy Grandma's Wi-Fi Password</h3>
    <p class="author">By Jane Doe</p>
    <p class="text">In an extraordinary twist of fate, Grandma Edna found herself at the forefront of a potential crisis
      when her clever Wi-Fi security measures unexpectedly thwarted an alien invasion. As alien spacecraft descended
      upon the town, panic spread until Grandma Edna calmly intervened, resetting her router with a cryptic passphrase
      known only to her.</p>
    <p class="text">The aliens, encountering unforeseen technological barriers, struggled to breach Grandma Edna's
      fortified network. Frustrated and bewildered, they eventually retreated to reassess their invasion strategy,
      leaving residents both relieved and amazed at Grandma Edna's resourcefulness.</p>
  </main>
</body>

</html>
```

```css
html {
  font-size: 24px;
  background-color: MintCream;
  padding-top: 100px;
}

.newspaper {
  font-family: 'Open Sans', sans-serif;
  max-width: 800px;
  margin: 20px auto;
  padding: 20px;
  background-color: white;
  box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
  font-size: 16px;
}

.name {
  font-family: 'Times New Roman', serif;
  font-size: 2rem;
  text-transform: uppercase;
  text-align: center;
  margin-bottom: 10px;
}

.date {
  font-size: 1em;
  text-align: center;
  margin-bottom: 20px;
}

.headline {
  font-size: 2em;
  font-weight: bold;
  line-height: 1.2;
  margin-bottom: 10px;
}

.sub-headline {
  font-size: 1.5em;
  font-style: italic;
  font-weight: 100;
  line-height: 1.4;
  margin-bottom: 15px;
}

.author {
  font-size: 1em;
  text-transform: uppercase;
  font-weight: bold;
  margin-bottom: 20px;
}

.text {
  text-indent: 20px;
  font-size: 1em;
  line-height: 2em;
  margin-bottom: 15px;
}

.text::first-letter {
  font-size: 2em;
  font-weight: bold;
}
```
