---
id: 66be24cb4144f955b6bcc550
title: Build a Page of Playing Cards
challengeType: 25
dashedName: build-a-page-of-playing-cards
demoType: onClick
saveSubmissionToDB: true
---

# --description--

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should build a webpage that displays at least three playing cards.
1. You should have a `main` element with an ID of `playing-cards`.
1. Within your `#playing-cards` element, you should have at least three `div` elements, each with a class of `card`.
1. Within each `.card` element, you should have three `div` elements, the first with a class of `left`, the second with a class of `middle`, and the third with a class of `right`.
1. Your `#playing-cards` element should use flexbox to horizontally center its children, allow them to wrap, and put a `20px` space between them.
1. Each of your `.card` elements should use flexbox to justify its children using `space-between`.
1. Each of your `.left` elements should use flexbox item properties to align itself at the start of its' parent container.
1. Each of your `.middle` elements should use flexbox item properties to align itself in the center of its' parent container.
1. Each of your `.right` elements should use flexbox item properties to align itself at the end of its parent container.
1. Each of your `.middle` elements should use flexbox to display its children in a column.

Here are some characters you can copy and paste to use in your cards if you want: `♠`, `♣`, `♥`, and `♦`.

# --hints--

You should have a `main` element with an `id` of `playing-cards`.

```js
assert.exists(document.querySelector('main#playing-cards'));
```

You should have at least three `div` elements with a class of `card` within your `#playing-cards` element.

```js
assert.isAtLeast(document.querySelectorAll('#playing-cards > div.card')?.length, 3);
```

Each of your `.card` elements should have a width and height.

```js
const els = document.querySelectorAll('.card');
assert.isAtLeast(els.length, 1);
els.forEach(el => {
  assert.isAbove(el.clientWidth, 0);
  assert.isAbove(el.clientHeight, 0);
});
```

Each of your `.card` elements should have exactly three `div` elements as children.

```js
const els = document.querySelectorAll('.card');
assert.isAtLeast(els.length, 1);
els.forEach(el => {
  const children = el.children;
  assert.lengthOf(children, 3);
  Array.from(children).forEach(child => {
    assert.equal(child.tagName, 'DIV');
  });
});
```

You should have a `div` with a class of `left` within each `.card` element.

```js
const els = document.querySelectorAll('.card');
assert.isAtLeast(els.length, 1);
els.forEach(el => assert.exists(el.querySelector('div.left')));
```

You should have a `div` with a class of `middle` within each `.card` element.

```js
const els = document.querySelectorAll('.card');
assert.isAtLeast(els.length, 1);
els.forEach(el => assert.exists(el.querySelector('div.middle')));
```

You should have a `div` with a class of `right` within each `.card` element.

```js
const els = document.querySelectorAll('.card');
assert.isAtLeast(els.length, 1);
els.forEach(el => assert.exists(el.querySelector('div.right')));
```

You should have a `#playing-cards` selector that sets its elements' `display` to `flex`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('#playing-cards')?.display, 'flex');
```

You should have a `#playing-cards` selector that sets its elements' `justify-content` to `center`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('#playing-cards')?.justifyContent, 'center');
```

You should have a `#playing-cards` selector that sets its elements' `flex-wrap` to `wrap`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('#playing-cards')?.flexWrap, 'wrap');
```

You should have a `#playing-cards` selector that sets its elements' `gap` to `20px`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('#playing-cards')?.gap, '20px');
```

You should have a `.card` selector that sets its elements' `display` to `flex`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.card')?.display, 'flex');
```

You should have a `.card` selector that sets its elements' `justify-content` to `space-between`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.card')?.justifyContent, 'space-between');
```

You should have a `.left` selector that sets its elements' `align-self` to `flex-start`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.left')?.alignSelf, 'flex-start');
```

You should have a `.middle` selector that sets its elements' `align-self` to `center`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.middle')?.alignSelf, 'center');
```

You should have a `.right` selector that sets its elements' `align-self` to `flex-end`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.right')?.alignSelf, 'flex-end');
```

You should have a `.middle` selector that sets its elements' `display` to `flex`.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.middle')?.display, 'flex');
```

You should have a `flex-direction` set to `column` in your `.middle` class.

```js
assert.equal(new __helpers.CSSHelp(document).getStyle('.middle')?.flexDirection, 'column');
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Playing Cards</title>

</head>

<body>

</body>

</html>
```

```css

```

# --solutions--

```html
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Straight</title>
  <link rel="stylesheet" href="styles.css">
</head>

<body>
  <main id="playing-cards">
    <div class="card">
      <div class="left">
        <div>A</div>
        <div>♠</div>
      </div>
      <div class="middle">
        <div>♠</div>
      </div>
      <div class="right">
        <div class="flipped">♠</div>
        <div class="flipped">A</div>
      </div>
    </div>

    <div class="card">
      <div class="left">
        <div>2</div>
        <div>♣</div>
      </div>
      <div class="middle">
        <div>♣</div>
        <div class="flipped">♣</div>
      </div>
      <div class="right">
        <div class="flipped">♣</div>
        <div class="flipped">2</div>
      </div>
    </div>

    <div class="card red">
      <div class="left">
        <div>3</div>
        <div>♥</div>
      </div>
      <div class="middle">
        <div>♥</div>
        <div>♥</div>
        <div class="flipped">♥</div>
      </div>
      <div class="right">
        <div class="flipped">♥</div>
        <div class="flipped">3</div>
      </div>
    </div>

    <div class="card">
      <div class="left">
        <div>4</div>
        <div>♣</div>
      </div>
      <div class="middle">
        <div class="middle-section">
          <div>♣</div>
          <div>♣</div>
        </div>
        <div class="middle-section">
          <div class="flipped">♣</div>
          <div class="flipped">♣</div>
        </div>
      </div>
      <div class="right">
        <div class="flipped">♣</div>
        <div class="flipped">4</div>
      </div>
    </div>

    <div class="card red">
      <div class="left">
        <div>5</div>
        <div>♦</div>
      </div>
      <div class="middle">
        <div class="middle-section">
          <div>♦</div>
          <div>♦</div>
        </div>
        <div class="middle-section">
          <div>♦</div>
        </div>
        <div class="middle-section">
          <div>♦</div>
          <div>♦</div>
        </div>
      </div>
      <div class="right">
        <div class="flipped">♦</div>
        <div class="flipped">5</div>
      </div>
    </div>
  </main>
</body>

</html>
```

```css
body {
  background-color: Thistle;
  min-height: 100vh;
}

.red {
  color: red;
}

.flipped {
  transform: rotate(180deg);
}

#playing-cards {
  margin-top: 100px;
  display: flex;
  justify-content: center;
  gap: 20px;
  flex-wrap: wrap;
}

.card {
  background-color: white;
  border: 1px solid black;
  border-radius: 10px;
  box-shadow: 2px 2px 2px gray;
  min-width: 250px;
  max-width: 250px;
  height: 350px;
  font-size: 30px;
  font-weight: bold;
  padding: 5px;
  box-sizing: border-box;
  display: flex;
  justify-content: space-between;
  text-align: center;
}

.left {
  align-self: flex-start;
}

.middle {
  align-self: center;
  display: flex;
  font-size: 80px;
  flex-direction: column;
}

.right {
  align-self: flex-end;
}

.middle-section {
  display: flex;
  justify-content: center;
}
```
