---
id: 66f17db06803d11a1bd19a20
title: Build a Quiz Game
challengeType: 26
dashedName: lab-quiz-game
---

# --description--

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should create an array named `questions`.
1. The `questions` array should contain at least five objects, each having the keys `category`, `question`, `choices`, and `answer`.
1. The `category` key should have the value of a string representing a question category.
1. The `question` key should have the value of a string representing a question.
1. The `choices` key should have the value of an array containing three strings, which are alternative answers to the question.
1. The `answer` key should have the value of a string, representing the correct answer to the question. Also, the value of `answer` should be included in the `choices` array.
1. You should have a function named `getRandomQuestion` that takes an array of questions as a parameter and returns a random question object from the array.
1. You should have a function named `getRandomComputerChoice` that takes the array of the available choices as a parameter, and returns a random answer to the selected question.
1. You should have a function named `getResults` that takes the question object as the first parameter and the computer's choice as the second parameter. The function should return `The computer's choice is correct!` if the answer is correct. Otherwise, it returns `The computer's choice is wrong. The correct answer is: <correct-answer>`, where `<correct-answer>` is the value of the correct answer to the chosen question.

# --hints--

You should create an array named `questions`.

```js
assert.isArray(questions);
```

The `questions` array should contain at least five objects, each having the keys `category`, `question`, `choices`, and `answer`.

```js
assert.isAtLeast(questions.length, 5);
questions.forEach(question => {
    assert.isObject(question);
    assert.hasAllKeys(question, ['category', 'choices', 'question', 'answer']);
});

```

The `category` key should have the value of a string representing a question category.

```js
assert.isNotEmpty(questions);
questions.forEach(({category}) => {
    assert.isString(category);
    assert.isNotEmpty(category);
});
```

The `question` key should have the value of a string representing a question.

```js
assert.isNotEmpty(questions);
questions.forEach(({question}) => {
    assert.isString(question);
    assert.include(question, '?');
    assert.isNotEmpty(question.replaceAll('?', ''));
})
```

The `choices` key should have the value of an array containing three strings different from each other.

```js
assert.isNotEmpty(questions);
questions.forEach(({choices}) => {
    assert.isArray(choices);
    assert.lengthOf(choices, 3);
    assert.lengthOf(new Set(choices), 3);
    choices.forEach(choice => {
        assert.isString(choice);
        assert.isNotEmpty(choice);
    });
})
```

The `answer` key should have the value of a string.

```js
assert.isNotEmpty(questions);
questions.forEach(({answer}) => {
    assert.isString(answer);
    assert.isNotEmpty(answer);
});
```

The value of `answer` should be included in the `choices` array.

```js
assert.isNotEmpty(questions);
questions.forEach(({answer, choices}) => assert.oneOf(answer, choices));
```

You should have a function named `getRandomQuestion` that takes an array of questions as a parameter and returns a random question object from the array.

```js
const parameters = __helpers.getFunctionParams(getRandomQuestion.toString());

assert.isFunction(getRandomQuestion);
assert.lengthOf(parameters, 1);
assert.lengthOf(getRandomQuestion, 1);
assert.isObject(getRandomQuestion(questions));
assert.deepInclude(questions, getRandomQuestion(questions), "getRandomQuestion did not return one of the objects inside questions");
```

You should have a function named `getRandomComputerChoice` that takes the array of the available choices as a parameter, and returns a random answer to the selected question.

```js
assert.isFunction(getRandomComputerChoice);
const randomArray = ['a', 'b', 'c'];
assert.oneOf(getRandomComputerChoice(randomArray), randomArray)
```

You should have a function named `getResults`.

```js
assert.isFunction(getResults);
```

Your `getResults` function should take the question object as the first parameter and the computer's choice as the second parameter.

```js
const testQuestion = questions[0];
const wrongChoice = questions[0].choices.find(choice => choice !== questions[0].answer);
assert.equal(getResults(testQuestion, testQuestion.answer), `The computer's choice is correct!`);
assert.equal(getResults(testQuestion, wrongChoice), `The computer's choice is wrong. The correct answer is: ${testQuestion.answer}`);
```

If the computer choice matches the answer, `getResults` should return `The computer's choice is correct!`

```js
assert.equal(getResults(questions[0], questions[0].answer), `The computer's choice is correct!`);
```

If the computer choice doesn't match the answer, `getResults` should return `The computer's choice is wrong. The correct answer is: <correct-answer>`, where `<correct-answer>` is the value of the correct answer to the chosen question.

```js
assert.equal(getResults({category: 'misc', choices: ['a', 'b', 'c'], question: "question?", answer: "b"}, "a"), `The computer's choice is wrong. The correct answer is: b`)
```

Your `getResults` function should use exact equality comparison, not substring matching.

```js
assert.equal(getResults({category: 'food', choices: ['Ham', 'Hamburger', 'Hot Dog'], question: "What food?", answer: "Hamburger"}, "Ham"), `The computer's choice is wrong. The correct answer is: Hamburger`);
assert.equal(getResults({category: 'food', choices: ['Ham', 'Hamburger', 'Hot Dog'], question: "What food?", answer: "Ham"}, "Hamburger"), `The computer's choice is wrong. The correct answer is: Ham`);
```

# --seed--

## --seed-contents--

```js

```

# --solutions--

```js
const questions = [
    {
        category: "science",
        question: "What is the chemical symbol for potassium?",
        choices: ["P", "K", "Pt"],
        answer: "K"
    },
    {
        category: "science",
        question: "What is the unit of electrical resistance?",
        choices: ["Ohm", "Coulomb", "Sievert"],
        answer: "Ohm"
    },
    {
        category: "geography",
        question: "What is the capital city of Australia?",
        choices: ["Sidney", "Canberra", "Wellington"],
        answer: "Canberra"
    },
    {
        category: "literature",
        question: 'Who wrote "1984"?',
        choices: ["Ray Bradbury", "Aldous Huxley", "George Orwell"],
        answer: "George Orwell"
    },
    {
        category: "sport",
        question: "How many players are on a standard volleyball team?",
        choices: ["6", "7", "12"],
        answer: "6"
    }
]

function getRandomQuestion(questionList) {
    const randomIndex = Math.floor(Math.random() * questionList.length);
    return questionList[randomIndex];
}

function getRandomComputerChoice(choices) {
    const randomIndex = Math.floor(Math.random() * choices.length);
    return choices[randomIndex];
}

function getResults(obj, computerChoice) {
    return computerChoice === obj.answer
        ? "The computer's choice is correct!"
        : `The computer's choice is wrong. The correct answer is: ${obj.answer}`;
}

const questionObj = getRandomQuestion(questions);
const { question, choices } = questionObj;

console.log(question);
console.log(`Choices: ${choices}`);

const computerChoice = getRandomComputerChoice(choices);
console.log(`Computer chooses: ${computerChoice}`);

const results = getResults(questionObj, computerChoice);
console.log(results);

```
