---
id: 66b62d0ad68488dd76228d6c
title: Debug a Random Background Color Changer
challengeType: 25
dashedName: debug-a-random-background-color-changer
demoType: onClick
---

# --description--

Camperbot is learning JavaScript and has tried to build their own Random Background Color Changer. However, they have made a few mistakes along the way.   

**Objective:** Fulfill the user stories below and get all the tests to pass so the lab is functioning properly.

**User Stories:**

1. You should fix the syntax errors in the `darkColorsArr` array.
1. You should fix the `ReferenceError` thrown when the `math` object is referenced inside the `getRandomIndex` function.
1. You should round down `randomIndex` to the nearest whole number.
1. You should update the value of the `body` variable to use the correct method name and fix the related `TypeError`.
1. You should fix `bgHexCodeSpanElement` so that it correctly selects the element with the `id` of `bg-hex-code`.
1. You should modify the `color` variable inside `changeBackgroundColor` so that it is set to a random color from the `darkColorsArr` array.
1. You should update the `btn` variable so that it targets the button element. Open up the `index.html` to see the correct `id` name for that button element.
1. You should fix the line that adds an event listener for the `click` event to `btn` by passing a reference to the `changeBackgroundColor` function to the method.
1. Your background should randomly change to one of the colors in `darkColorsArr` each time the `#btn` is clicked.

# --hints--

You should resolve the syntax errors in the `darkColorsArr` array. Remember that array elements should be separated by commas.

```js
assert.isArray(darkColorsArr);
```

You should fix the capitalization error in the `math.random()` line. 

```js
assert.match(getRandomIndex.toString(), /\s*(darkColorsArr\.length\s*\*\s*Math\.random\(\s*\)|Math\.random\(\s*\)\s*\*\s*darkColorsArr\.length)\s*/);
```

You should round `darkColorsArr.length * Math.random()` down to the nearest whole number.

```js
assert.match(getRandomIndex.toString(), /Math\.floor\(\s*(darkColorsArr\.length\s*\*\s*Math\.random\(\s*\)|Math\.random\(\s*\)\s*\*\s*darkColorsArr\.length)\s*\)/);
```

You should update the value of your `body` variable so that `queryselector` uses camel case.

```js
assert.match(code, /const\s+body\s*=\s*document\.querySelector\s*\(\s*("|')body\1\s*\)/);
```

You should fix `"bg-hex-code"` so it correctly references the `id` of `bg-hex-code`. Remember that `id` selectors in CSS start with a hash symbol (`#`).

```js
assert.match(bgHexCodeSpanElement.id, /bg-hex-code/);
```

You should call the `getRandomIndex` function inside the `darkColorsArr[getRandomIndex]` line.

```js
assert.match(changeBackgroundColor.toString(), /darkColorsArr\[\s*getRandomIndex\(\s*\)\s*\]/);
```

You should fix the `id` name of `"#click-btn"` line to match the correct `id` name in the `index.html` file.

```js
assert.match(btn?.id, /btn/);
```

You should not call the `changeBackgroundColor` function. Instead, you should pass the function reference to the `addEventListener` method.

```js
assert.match(code, /btn\.addEventListener\s*\(\s*("|')click\1\s*,\s*changeBackgroundColor\s*\)/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Debug a random background color changer</title>
    <link rel="stylesheet" href="./styles.css" />
</head>

<body>
    <h1>Random Background Color changer</h1>

    <main>
        <section class="bg-information-container">
            <p>Hex Code: <span id="bg-hex-code">#110815</span></p>
        </section>

        <button class="btn" id="btn">Change Background Color</button>
    </main>
    <script src="./script.js"></script>
</body>

</html>
```

```css
*,
*::before,
*::after {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

:root {
    --yellow: #f1be32;
    --golden-yellow: #feac32;
    --dark-purple: #110815;
    --light-grey: #efefef;
}

body {
    background-color: var(--dark-purple);
    color: var(--light-grey);
    text-align: center;
}

.bg-information-container {
    margin: 15px 0 25px;
    font-size: 1.2rem;
}

.btn {
    cursor: pointer;
    padding: 10px;
    margin: 10px;
    color: var(--dark-purple);
    background-color: var(--golden-yellow);
    background-image: linear-gradient(#fecc4c, #ffac33);
    border-color: var(--golden-yellow);
    border-width: 3px;
}

.btn:hover {
    background-image: linear-gradient(#ffcc4c, #f89808);
}
```

```js
const darkColorsArr = [
    "#2C3E50",
    "#34495E",
    "#2C2C2C"
    "#616A6B"
    "#4A235A"
    "#2F4F4F",
    "#0E4B5A",
    "#36454F",
    "#2C3E50",
    "#800020",
  ];
  
  function getRandomIndex() {
    const randomIndex = darkColorsArr.length * math.random();
    return randomIndex;
  }
  console.log(getRandomIndex())
  
  const body = document.queryselector("body");
  const bgHexCodeSpanElement = document.querySelector("bg-hex-code");
  console.log(bgHexCodeSpanElement)
  
  function changeBackgroundColor() {
    const color = darkColorsArr[getRandomIndex];
  
    bgHexCodeSpanElement.innerText = color;
    body.style.backgroundColor = color;
  }
  const btn = document.querySelector("#click-btn");
  console.log(btn)
  
  btn.addEventListener("click", changeBackgroundColor());
```

# --solutions--

```html
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Debug a random background color changer</title>
    <link rel="stylesheet" href="./styles.css" />
</head>

<body>
    <h1>Random Background Color changer</h1>

    <main>
        <section class="bg-information-container">
            <p>Hex Code: <span id="bg-hex-code">#110815</span></p>
        </section>

        <button class="btn" id="btn">Change Background Color</button>
    </main>
    <script src="./script.js"></script>
</body>

</html>
```

```css
*,
*::before,
*::after {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

:root {
    --yellow: #f1be32;
    --golden-yellow: #feac32;
    --dark-purple: #110815;
    --light-grey: #efefef;
}

body {
    background-color: var(--dark-purple);
    color: var(--light-grey);
    text-align: center;
}

.bg-information-container {
    margin: 15px 0 25px;
    font-size: 1.2rem;
}

.btn {
    cursor: pointer;
    padding: 10px;
    margin: 10px;
    color: var(--dark-purple);
    background-color: var(--golden-yellow);
    background-image: linear-gradient(#fecc4c, #ffac33);
    border-color: var(--golden-yellow);
    border-width: 3px;
}

.btn:hover {
    background-image: linear-gradient(#ffcc4c, #f89808);
}
```

```js
const darkColorsArr = [
  "#2C3E50",
  "#34495E",
  "#2C2C2C",
  "#616A6B",
  "#4A235A",
  "#2F4F4F",
  "#0E4B5A",
  "#36454F",
  "#2C3E50",
  "#800020",
];

function getRandomIndex() {
  const randomIndex = Math.floor(darkColorsArr.length * Math.random());
  return randomIndex;
}

const body = document.querySelector("body");
const bgHexCodeSpanElement = document.querySelector("#bg-hex-code");

function changeBackgroundColor() {
  const color = darkColorsArr[getRandomIndex()];

  bgHexCodeSpanElement.innerText = color;
  body.style.backgroundColor = color;
}
const btn = document.querySelector("#btn");

btn.addEventListener("click", changeBackgroundColor);
```
