---
id: 67d83df6f82eda3868dd2a84
title: Build an RPG Character
challengeType: 27
dashedName: build-an-rpg-character
---

# --description--

In this lab you will practice the basics of Python by building a small app that creates a character for an RPG adventure.

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should have a function named `create_character`.
1. The function should accept, in order, a character name followed by three stats: strength, intelligence, and charisma.
1. The character name should be validated:
   - If the character name is not a string, the function should return `The character name should be a string`.
   - If the character name is an empty string, the function should return `The character should have a name`.
   - If the character name is longer than 10 characters, the function should return `The character name is too long`.
   - If the character name contains spaces, the function should return `The character name should not contain spaces`.
1. The stats should also be validated:
   - If one or more stats are not integers, the function should return `All stats should be integers`.
   - If one or more stats are less than 1, the function should return `All stats should be no less than 1`.
   - If one or more stats are more than 4, the function should return `All stats should be no more than 4`.
   - If the sum of all stats is different than 7, the function should return `The character should start with 7 points`.
1. If all values pass the verification, the function should return a string with four lines:
   - the first line should contain the character name
   - lines 2-4 should start with the stat abbreviation, `STR`, `INT` or `CHA` (in this order), then a space, and then a number of full dots (`●`) equal to the value of the stat, and a number of empty dots (`○`) to reach 10. Example: if the value of strength is 3 there must be 3 full dots followed by 7 empty dots. The dots are given in the editor.

Here's the string that should be returned by `create_character('ren', 4, 2, 1)`:

   ```md
   ren
   STR ●●●●○○○○○○
   INT ●●○○○○○○○○
   CHA ●○○○○○○○○○
   ```

NOTE: while `str` and `int` are common abbreviations for the stats, remember that those are reserved keywords in Python and should not be used as variable names.

# --hints--

You should have a function named `create_character`.

```js
({
    test: () => runPython(
`
assert _Node(_code).has_function('create_character')
`
    )
})
```

When `create_character` is called with a first argument that is not a string it should return `The character name should be a string`.

```js
({
    test: () => runPython(
        `
wrong_types = [3, 5, {'a': 3}, 3.1, [1, 2], (1, 2), {1, 2}]
for wrong_type in wrong_types:
    assert create_character(wrong_type, 1, 2, 4) == 'The character name should be a string'

# even if wrong numbers, wrong type has precedence

assert create_character(1, 1, 1, 1) == 'The character name should be a string'
`
    )
})
```

When `create_character` is called with a first argument that is an empty string, it should return `The character should have a name`.

```js
({
    test: () => runPython(
        `
assert create_character('', 4, 2, 1) == 'The character should have a name'
`
    )
})
```

When `create_character` is called with a first argument that is longer than 10 characters it should return `The character name is too long`.

```js
({
    test: () => runPython(
        `
for length in range(11, 27):
    assert create_character('abcdefghijklmnopqrstuvwxyz'[:length], 4, 2, 1) == 'The character name is too long'
`
    )
})
```

The `create_character` function should not say that the character is too long when it's not longer than 10 characters.

```js
({
    test: () => runPython(
        `
for length in range(0, 11):
  assert create_character('aaabbcccdd'[:length], 4, 2, 1) != 'The character name is too long'
`
    )
})
```

When `create_character` is called with a first argument that contains a space it should return `The character name should not contain spaces`.

```js
({
    test: () => runPython(
        `
assert create_character('cha cha', 4, 1, 2) == 'The character name should not contain spaces'
`
    )
})
```

When `create_character` is called with a second, third or fourth argument that is not an integer it should return `All stats should be integers`.

```js
({
    test: () => runPython(
        `
wrong_types = ['3', '5', {'a': 3}, 3.1, [1, 2], (1, 2), {1, 2}, 'str', 'friend']
for wrong_type in wrong_types:
    assert create_character('friend', wrong_type, 2, 1) == 'All stats should be integers'
    assert create_character('friend', 2, wrong_type, 1) == 'All stats should be integers'
    assert create_character('friend', 2, 1, wrong_type) == 'All stats should be integers'
`
    )
})
```

When `create_character` is called with a second, third or fourth argument that is lower than `1` it should return `All stats should be no less than 1`.

```js
({
    test: () => runPython(
        `
expected = 'All stats should be no less than 1'

assert create_character('ren', 0, 4, 3) == expected
assert create_character('ren', 4, 0, 3) == expected
assert create_character('ren', 4, 3, 0) == expected
assert create_character('ren', -1, 4, 4) == expected
assert create_character('ren', 4, -1, 4) == expected
assert create_character('ren', 4, 4, -1) == expected
`
    )
})
```

When `create_character` is called with a second, third or fourth argument that is higher than `4` it should return `All stats should be no more than 4`.

```js
({
    test: () => runPython(
        `
assert create_character('ren', 1, 5, 1) == 'All stats should be no more than 4'
assert create_character('ren', 5, 1, 1) == 'All stats should be no more than 4'
assert create_character('ren', 1, 1, 5) == 'All stats should be no more than 4'
assert create_character('ren', 1, 1, 7) == 'All stats should be no more than 4'
assert create_character('ren', 1, 7, 1) == 'All stats should be no more than 4'
assert create_character('ren', 7, 1, 1) == 'All stats should be no more than 4'
`
    )
})
```

When `create_character` is called with a second, third or fourth argument that do not sum to `7` it should return `The character should start with 7 points`.

```js
({
    test: () => runPython(
        `
assert create_character('ren', 4, 4, 4) == 'The character should start with 7 points'
assert create_character('ren', 1, 1, 1) == 'The character should start with 7 points'
assert create_character('ren', 1, 2, 3) == 'The character should start with 7 points'
`
    )
})
```

`create_character('ren', 4, 2, 1)` should return `ren\nSTR ●●●●○○○○○○\nINT ●●○○○○○○○○\nCHA ●○○○○○○○○○`.

```js
({
    test: () => runPython(
        `
assert create_character('ren', 4, 2, 1) == f'ren\\nSTR ●●●●○○○○○○\\nINT ●●○○○○○○○○\\nCHA ●○○○○○○○○○'
`
    )
})
```

When `create_character` is called with valid values it should output the character stats as required.

```js
({
    test: () => runPython(
        `
assert create_character('Bob', 1, 2, 4) == f'Bob\\nSTR ●○○○○○○○○○\\nINT ●●○○○○○○○○\\nCHA ●●●●○○○○○○'
assert create_character('aaabbbcccd', 4, 2, 1) == f'aaabbbcccd\\nSTR ●●●●○○○○○○\\nINT ●●○○○○○○○○\\nCHA ●○○○○○○○○○'
`
    )
})

```

# --seed--

## --seed-contents--

```py
full_dot = '●'
empty_dot = '○'


```

# --solutions--

```py
full_dot = '●'
empty_dot = '○'

def create_character(character_name, strength, intelligence, charisma):
    if type(character_name) != str:
        return 'The character name should be a string'
    if len(character_name) == 0:
        return 'The character should have a name'
    if len(character_name) > 10:
        return 'The character name is too long'
    if ' ' in character_name:
        return 'The character name should not contain spaces'

    if type(strength) != int or type(intelligence) != int or type(charisma) != int:
       return 'All stats should be integers'
    if strength < 1 or intelligence < 1 or charisma < 1:
        return 'All stats should be no less than 1'
    if strength > 4 or intelligence > 4 or charisma > 4:
        return 'All stats should be no more than 4'
    if strength + intelligence + charisma != 7:
        return 'The character should start with 7 points'

    character_sheet = f'{character_name}\n'
    character_sheet += f'STR {full_dot * strength}{empty_dot * (10 - strength)}\n'
    character_sheet += f'INT {full_dot * intelligence}{empty_dot * (10 - intelligence)}\n'
    character_sheet += f'CHA {full_dot * charisma}{empty_dot * (10 - charisma)}'
    return character_sheet
```
