---
id: 66c057041df6394ca796bf33
title: Build a Sentence Maker
challengeType: 26
dashedName: build-a-sentence-maker
---

# --description--

In this lab, you will create two different stories using a sentence template. You will use variables to store different parts of the story and then output the stories to the console.

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should declare the following variables using `let`:
   
    - `adjective`
    - `noun`
    - `verb`
    - `place`
    - `adjective2`
    - `noun2`

1. You should assign the above variables some string values of your choice.

1. You should declare a `firstStory` variable.
   
1. You should use the following story template to create the first story and assign it to the `firstStory` variable: `"Once upon a time, there was a(n) [adjective] [noun] who loved to eat [noun2]. The [noun] lived in a [place] and had [adjective2] nostrils that blew fire when it was [verb]."`;

1. You should output your first story to the console using the message `"First story: [firstStory]"`.

1. You should assign new values to your `adjective`, `noun`, `verb`, `place`, `adjective2`, and `noun2` variables.

1. You should declare a `secondStory` variable.

1. Create another story using the same template and assign it to the `secondStory` variable.

1. You should output your second story to the console using the message `"Second story: [secondStory]"`.


# --hints--

You should declare an `adjective` variable.

```js
assert.isNotNull(adjective);
```

You should declare a `noun` variable.

```js
assert.isNotNull(noun);
```

You should declare a `verb` variable.

```js
assert.isNotNull(verb);
```

You should declare a `place` variable.

```js
assert.isNotNull(place);
```

You should declare an `adjective2` variable.

```js
assert.isNotNull(adjective2);
```

You should declare a `noun2` variable.

```js
assert.isNotNull(noun2);
```

You should assign a string value to the `adjective` variable.

```js
assert.isString(adjective);
```

You should assign a string value to the `noun` variable.

```js
assert.isString(noun);
```

You should assign a string value to the `verb` variable.

```js
assert.isString(verb);
```

You should assign a string value to the `place` variable.

```js
assert.isString(place);
```

You should assign a string value to the `adjective2` variable.

```js
assert.isString(adjective2);
```

You should assign a string value to the `noun2` variable.

```js
assert.isString(noun2);
```

You should declare a `firstStory` variable.

```js
assert.isNotNull(firstStory);
```

You should use the correct story format for the first story: `"Once upon a time, there was a(n) [adjective] [noun] who loved to eat [noun2]. The [noun] lived in a [place] and had [adjective2] nostrils that blew fire when it was [verb]."`. Pay attention to spaces.

```js
const _initialValues = {}
for (const name of ['adjective', 'noun', 'noun2', 'place', 'verb', 'adjective2']) {
    const match = code.match(new RegExp(String.raw`${name}\s*=\s*('|"|${'`'})(?<${name}>.*?)\1(?:,|;|\s|$)`, 'm'));
    _initialValues[name] = match ? match.groups[name] : null;
}

const expected = `Once upon a time, there was a(n) ${_initialValues['adjective']} ${_initialValues['noun']} who loved to eat ${_initialValues['noun2']}. The ${_initialValues['noun']} lived in a ${_initialValues['place']} and had ${_initialValues['adjective2']} nostrils that blew fire when it was ${_initialValues['verb']}.`;

assert.strictEqual(firstStory, expected);
```

You should assemble your first story using the variables you declared in the correct order.

```js
assert.match(
  __helpers.removeJSComments(code),
  /firstStory\s*=\s*.*?adjective.*?noun.*?noun2.*?noun.*?place.*?adjective2.*?verb/
);
```

You should log your first story using the message `"First story: [firstStory]"`.

```js
const condition1 = /console\.log\(\s*["']First\s+story:\s+["']\s*\+\s*firstStory\s*\);?/gm.test(code);
const condition2 = /console\.log\(\s*`First\s+story:\s+\$\{firstStory\}`\s*\);?/gm.test(code);
assert.isTrue(condition1 || condition2);
```

You should declare a `secondStory` variable.

```js
assert.isNotNull(secondStory);
```

You should reassign the `adjective` variable for the second story.

```js
assert.lengthOf(__helpers.removeJSComments(code).match(/adjective\s*=\s*/g), 2);
```

You should reassign the `noun` variable for the second story.

```js
assert.lengthOf(__helpers.removeJSComments(code).match(/noun\s*=\s*/g), 2);
```

You should reassign the `verb` variable for the second story.

```js
assert.lengthOf(__helpers.removeJSComments(code).match(/verb\s*=\s*/g), 2);
```

You should reassign the `place` variable for the second story.

```js
assert.lengthOf(__helpers.removeJSComments(code).match(/place\s*=\s*/g), 2);
```

You should reassign the `adjective2` variable for the second story.

```js
assert.lengthOf(__helpers.removeJSComments(code).match(/adjective2\s*=\s*/g), 2);
```

You should reassign the `noun2` variable for the second story.

```js
assert.lengthOf(__helpers.removeJSComments(code).match(/noun2\s*=\s*/g), 2);
```

You should use the correct story format for the second story: `"Once upon a time, there was a(n) [adjective] [noun] who loved to eat [noun2]. The [noun] lived in a [place] and had [adjective2] nostrils that blew fire when it was [verb]."`. Pay attention to spaces.

```js
const expected = `Once upon a time, there was a(n) ${adjective} ${noun} who loved to eat ${noun2}. The ${noun} lived in a ${place} and had ${adjective2} nostrils that blew fire when it was ${verb}.`;
assert.strictEqual(secondStory, expected);
```

You should assemble your second story using the variables you declared in the correct order.

```js
assert.match(
  __helpers.removeJSComments(code),
  /secondStory\s*=\s*.*?adjective.*?noun.*?noun2.*?noun.*?place.*?adjective2.*?verb/
);
```

You should log your second story using the format `"Second story: [secondStory]"`.

```js
const condition1 = /console\.log\(\s*["']Second\s+story:\s+["']\s*\+\s*secondStory\s*\);?/gm.test(code);
const condition2 = /console\.log\(\s*`Second\s+story:\s+\$\{secondStory\}`\s*\);?/gm.test(code);
assert.isTrue(condition1 || condition2);
```

The `firstStory` should not be the same as the `secondStory`.

```js
assert.notEqual(firstStory, secondStory);
```

# --seed--

## --seed-contents--

```js

```

# --solutions--

```js
let adjective = "funny";
let noun = "dragon";
let verb = "jumping";
let place = "garden";
let adjective2 = "sparkling";
let noun2 = "cakes";

const firstStory = `Once upon a time, there was a(n) ${adjective} ${noun} who loved to eat ${noun2}. The ${noun} lived in a ${place} and had ${adjective2} nostrils that blew fire when it was ${verb}.`;

console.log("First story: " + firstStory);

adjective = "cute";
noun = "puppy";
verb = "barking";
place = "park";
adjective2 = "colorful";
noun2 = "flower";

const secondStory = `Once upon a time, there was a(n) ${adjective} ${noun} who loved to eat ${noun2}. The ${noun} lived in a ${place} and had ${adjective2} nostrils that blew fire when it was ${verb}.`;

console.log("Second story: " + secondStory);
```

