---
id: acda2fb1324d9b0fa741e6b5
title: Build a Confirm the Ending Tool
challengeType: 26
dashedName: implement-a-string-ending-checker-function
---

# --description--

In this lab, you will implement a function that checks if a string ends with the given target string.

**Objective:** Fulfill the user stories below and get all the tests to pass to complete the lab.

**User Stories:**

1. You should create a function named `confirmEnding` that takes two parameters: the string to check and the string to check against.
2. The function should return `true` if the first string ends with the second string, and `false` otherwise.
3. You should not use the `.endsWith()` method; instead, use one of the JavaScript substring methods to achieve this.

# --hints--

You should create a function named `confirmEnding`.

```js
assert.isFunction(confirmEnding);
```

`confirmEnding` should take 2 parameters.

```js
assert.lengthOf(confirmEnding, 2);
```

`confirmEnding("Bastian", "n")` should return `true`.

```js
assert.isTrue(confirmEnding('Bastian', 'n'));
```

`confirmEnding("Congratulation", "on")` should return `true`.

```js
assert.isTrue(confirmEnding('Congratulation', 'on'));
```

`confirmEnding("Connor", "n")` should return `false`.

```js
assert.isFalse(confirmEnding('Connor', 'n'));
```

`confirmEnding("Walking on water and developing software from a specification are easy if both are frozen", "specification")` should return `false`.

```js
assert.isFalse(
  confirmEnding(
    'Walking on water and developing software from a specification are easy if both are frozen',
    'specification'
  )
);
```

`confirmEnding("He has to give me a new name", "name")` should return `true`.

```js
assert.isTrue(confirmEnding('He has to give me a new name', 'name'));
```

`confirmEnding("Open sesame", "same")` should return `true`.

```js
assert.isTrue(confirmEnding('Open sesame', 'same'));
```

`confirmEnding("Open sesame", "sage")` should return `false`.

```js
assert.isFalse(confirmEnding('Open sesame', 'sage'));
```

`confirmEnding("Open sesame", "game")` should return `false`.

```js
assert.isFalse(confirmEnding('Open sesame', 'game'));
```

`confirmEnding("If you want to save our world, you must hurry. We don't know how much longer we can withstand the nothing", "mountain")` should return `false`.

```js
assert.isFalse(
  confirmEnding(
    "If you want to save our world, you must hurry. We don't know how much longer we can withstand the nothing",
    'mountain'
  )
);
```

`confirmEnding("Abstraction", "action")` should return `true`.

```js
assert.isTrue(confirmEnding('Abstraction', 'action'));
```

Your code should not use the built-in method `.endsWith()` to solve the lab.

```js
assert.notMatch(__helpers.removeJSComments(code), /\.endsWith\(.*?\)\s*?;?/);
assert.notMatch(__helpers.removeJSComments(code), /\['endsWith'\]/);
```

# --seed--

## --seed-contents--

```js

```

# --solutions--

```js
function confirmEnding(str, target) {
  return str.substring(str.length - target.length) === target;
}

confirmEnding('Bastian', 'n');
```
