---
id: 6143639d5eddc7094161648c
title: Step 20
challengeType: 0
dashedName: step-20
---

# --description--

It is important to link each `input` to the corresponding `label` element. This provides assistive technology users with a visual reference to the input.

This is done by giving the `label` a `for` attribute, which contains the `id` of the `input`.

This section will take a student's name, email address, and date of birth. Give the `label` elements appropriate `for` attributes, as well as text content. Then, link the `input` elements to the corresponding `label` elements.

# --hints--

You should give the first `label` element an appropriate `for` attribute.

```js
assert.isAtLeast(document.querySelectorAll('label')?.[0]?.htmlFor?.length, 1);
```

You should give the second `label` element an appropriate `for` attribute.

```js
assert.isAtLeast(document.querySelectorAll('label')?.[1]?.htmlFor?.length, 1);
```

You should give the third `label` element an appropriate `for` attribute.

```js
assert.isAtLeast(document.querySelectorAll('label')?.[2]?.htmlFor?.length, 1);
```

You should give the first `label` element an appropriate text content.

```js
assert.isAtLeast(document.querySelectorAll('label')?.[0]?.textContent?.length, 1);
```

You should give the second `label` element an appropriate text content.

```js
assert.isAtLeast(document.querySelectorAll('label')?.[1]?.textContent?.length, 1);
```

You should give the third `label` element an appropriate text content.

```js
assert.isAtLeast(document.querySelectorAll('label')?.[2]?.textContent?.length, 1);
```

You should give the first `input` element an `id` attribute matching the `for` attribute of the first `label`.

```js
assert.equal(document.querySelectorAll('input')?.[0]?.id, document.querySelectorAll('label')?.[0]?.htmlFor);
```

You should give the second `input` element an `id` attribute matching the `for` attribute of the second `label`.

```js
assert.equal(document.querySelectorAll('input')?.[1]?.id, document.querySelectorAll('label')?.[1]?.htmlFor);
```

You should give the third `input` element an `id` attribute matching the `for` attribute of the third `label`.

```js
assert.equal(document.querySelectorAll('input')?.[2]?.id, document.querySelectorAll('label')?.[2]?.htmlFor);
```

You should not use the same `id` attribute for more than one `input` element.

```js
const id = (n) => document.querySelectorAll('input')?.[n]?.id;
assert.notEqual(id(0), id(1));
assert.notEqual(id(0), id(2));
assert.notEqual(id(1), id(2));
```

You should not use the same `for` attribute for more than one `label` element.

```js
const htmlFor = (n) => document.querySelectorAll('label')?.[n]?.htmlFor;
assert.notEqual(htmlFor(0), htmlFor(1));
assert.notEqual(htmlFor(0), htmlFor(2));
assert.notEqual(htmlFor(1), htmlFor(2));
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="description" content="freeCodeCamp Accessibility Quiz practice project" />
    <title>Accessibility Quiz</title>
    <link rel="stylesheet" href="styles.css" />
  </head>
  <body>
    <header>
      <img id="logo" alt="freeCodeCamp" src="https://cdn.freecodecamp.org/platform/universal/fcc_primary.svg">
      <h1>HTML/CSS Quiz</h1>
      <nav>
        <ul>
          <li><a href="#student-info">INFO</a></li>
          <li><a href="#html-questions">HTML</a></li>
          <li><a href="#css-questions">CSS</a></li>
        </ul>
      </nav>
    </header>
    <main>
      <form method="post" action="https://freecodecamp.org/practice-project/accessibility-quiz">
--fcc-editable-region--
        <section role="region" aria-labelledby="student-info">
          <h2 id="student-info">Student Info</h2>
          <div class="info">
            <label></label>
            <input />
          </div>
          <div class="info">
            <label></label>
            <input />
          </div>
          <div class="info">
            <label></label>
            <input />
          </div>
        </section>
--fcc-editable-region--
        <section role="region" aria-labelledby="html-questions">
          <h2 id="html-questions">HTML</h2>
        </section>
        <section role="region" aria-labelledby="css-questions">
          <h2 id="css-questions">CSS</h2>
        </section>
      </form>
    </main>
  </body>
</html>

```

```css
body {
  background: #f5f6f7;
  color: #1b1b32;
  font-family: Helvetica;
  margin: 0;
}

header {
  width: 100%;
  height: 50px;
  background-color: #1b1b32;
  display: flex;
}

#logo {
  width: max(10rem, 18vw);
  background-color: #0a0a23;
  aspect-ratio: 35 / 4;
  padding: 0.4rem;
}

h1 {
  color: #f1be32;
  font-size: min(5vw, 1.2em);
}

nav {
  width: 50%;
  max-width: 300px;
  height: 50px;
}

nav > ul {
  display: flex;
  justify-content: space-evenly;
}

h1,
h2 {
  font-family: Verdana, Tahoma;
}

h2 {
  border-bottom: 4px solid #dfdfe2;
}

```
