---
id: 63507ebb0c50ce3b9d669cd9
title: Step 8
challengeType: 0
dashedName: step-8
---

# --description--

Array methods can often be chained together to perform multiple operations at once. As an example:

```js
array.map().filter();
```

The `.map()` method is called on the array, and then the `.filter()` method is called on the result of the `.map()` method. This is called method chaining.

Following that example, remove your `filtered` variable, and chain your `.filter()` call to your `.map()` call above. Do not remove either of the callback functions.

# --hints--

You should remove the `filtered` variable.

```js
assert.notMatch(calculate.toString(), /filtered/);
```

You should chain your `.filter()` call to your `.map()` call.

```js
assert.match(calculate.toString(), /array\.map\(.*\)\.filter\(/s);
```

You should not remove the `.map()` callback.

```js
assert.match(calculate.toString(), /(array\.map\(\s*(\(\s*el\s*\)|el)\s*=>|array\.map\(\s*function\s*\(\s*el\s*\)\s*\{)\s*(return\s+)?Number\(\s*el\s*\)/);
```

You should not remove the `.filter()` callback.

```js
assert.match(calculate.toString(), /(\.filter\(\s*(\(\s*el\s*\)|el)\s*=>|\.filter\(\s*function\s*\(\s*el\s*\)\s*\{)\s*(return\s*)?!(Number\.)?isNaN\(\s*el\s*\)/s);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <script src="./script.js"></script>
    <title>Statistics Calculator</title>
  </head>
  <body>
    <h1>Statistics Calculator</h1>
    <p>Enter a list of comma-separated numbers.</p>

    <form onsubmit="calculate();">
      <label for="numbers">Numbers:</label>
      <input type="text" name="numbers" id="numbers" />
      <button type="submit">Calculate</button>
    </form>
    <div class="results">
      <p>
        The <dfn>mean</dfn> of a list of numbers is the average, calculated by
        taking the sum of all numbers and dividing that by the count of numbers.
      </p>
      <p class="bold">Mean: <span id="mean"></span></p>
      <p>
        The <dfn>median</dfn> of a list of numbers is the number that appears in
        the middle of the list, when sorted from least to greatest.
      </p>
      <p class="bold">Median: <span id="median"></span></p>
      <p>
        The <dfn>mode</dfn> of a list of numbers is the number that appears most
        often in the list.
      </p>
      <p class="bold">Mode: <span id="mode"></span></p>
      <p>
        The <dfn>range</dfn> of a list of numbers is the difference between the
        largest and smallest numbers in the list.
      </p>
      <p class="bold">Range: <span id="range"></span></p>
      <p>
        The <dfn>variance</dfn> of a list of numbers measures how far the values
        are from the mean, on average.
      </p>
      <p class="bold">Variance: <span id="variance"></span></p>
      <p>
        The <dfn>standard deviation</dfn> of a list of numbers is the square
        root of the variance.
      </p>
      <p class="bold">
        Standard Deviation: <span id="standardDeviation"></span>
      </p>
    </div>
  </body>
</html>
```

```css
body {
  margin: 0;
  background-color: rgb(27, 27, 50);
  text-align: center;
  color: #fff;
}

button {
  cursor: pointer;
  background-color: rgb(59, 59, 79);
  border: 3px solid white;
  color: white;
}

input {
  background-color: rgb(10, 10, 35);
  color: white;
  border: 1px solid rgb(59, 59, 79);
}

.bold {
  font-weight: bold;
}
```

```js
--fcc-editable-region--
const calculate = () => {
  const value = document.querySelector("#numbers").value;
  const array = value.split(/,\s*/g);
  const numbers = array.map(el => Number(el));
  const filtered = numbers.filter(el => !isNaN(el));
}
--fcc-editable-region--
```
