---
id: 63508c898d753754757bd5e3
title: Step 21
challengeType: 0
dashedName: step-21
---

# --description--

By default, the `.sort()` method converts the elements of an array into strings, then sorts them alphabetically. The `.sort()` method mutates the original array. This works well for strings, but not so well for numbers. For example, `10` comes before `2` when sorted as strings, but `2` comes before `10` when sorted as numbers.

To fix this, you can pass in a callback function to the `.sort()` method. This function takes two arguments, which represent the two elements being compared. The function should return a value less than `0` if the first element should come before the second element, a value greater than `0` if the first element should come after the second element, and `0` if the two elements should remain in their current positions.

To sort your numbers from smallest to largest, pass a callback function that takes parameters `a` and `b`, and returns the result of subtracting `b` from `a`.

# --hints--

Your `sort` method should have a callback function which takes an `a` and a `b` parameters.

```js
assert.match(getMedian.toString(), /(array\.sort\(\s*\(\s*a\s*,\s*b\s*\)\s*=>|array\.sort\(\s*function\s*\(\s*a\s*,\s*b\s*\)\s*\{)/)
```

Your `sort` method should return the result of subtracting `b` from `a`.

```js
assert.match(getMedian.toString(), /(array\.sort\(\s*\(\s*a\s*,\s*b\s*\)\s*=>|array\.sort\(\s*function\s*\(\s*a\s*,\s*b\s*\)\s*\{)\s*(return\s+)?\s*a\s*\-\s*b/)
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <script src="./script.js"></script>
    <title>Statistics Calculator</title>
  </head>
  <body>
    <h1>Statistics Calculator</h1>
    <p>Enter a list of comma-separated numbers.</p>
    <form onsubmit="calculate(); return false;">
      <label for="numbers">Numbers:</label>
      <input type="text" name="numbers" id="numbers" />
      <button type="submit">Calculate</button>
    </form>
    <div class="results">
      <p>
        The <dfn>mean</dfn> of a list of numbers is the average, calculated by
        taking the sum of all numbers and dividing that by the count of numbers.
      </p>
      <p class="bold">Mean: <span id="mean"></span></p>
      <p>
        The <dfn>median</dfn> of a list of numbers is the number that appears in
        the middle of the list, when sorted from least to greatest.
      </p>
      <p class="bold">Median: <span id="median"></span></p>
      <p>
        The <dfn>mode</dfn> of a list of numbers is the number that appears most
        often in the list.
      </p>
      <p class="bold">Mode: <span id="mode"></span></p>
      <p>
        The <dfn>range</dfn> of a list of numbers is the difference between the
        largest and smallest numbers in the list.
      </p>
      <p class="bold">Range: <span id="range"></span></p>
      <p>
        The <dfn>variance</dfn> of a list of numbers measures how far the values
        are from the mean, on average.
      </p>
      <p class="bold">Variance: <span id="variance"></span></p>
      <p>
        The <dfn>standard deviation</dfn> of a list of numbers is the square
        root of the variance.
      </p>
      <p class="bold">
        Standard Deviation: <span id="standardDeviation"></span>
      </p>
    </div>
  </body>
</html>
```

```css
body {
  margin: 0;
  background-color: rgb(27, 27, 50);
  text-align: center;
  color: #fff;
}

button {
  cursor: pointer;
  background-color: rgb(59, 59, 79);
  border: 3px solid white;
  color: white;
}

input {
  background-color: rgb(10, 10, 35);
  color: white;
  border: 1px solid rgb(59, 59, 79);
}

.bold {
  font-weight: bold;
}
```

```js
const getMean = (array) => array.reduce((acc, el) => acc + el, 0) / array.length;

--fcc-editable-region--
const getMedian = (array) => {
  const sorted = array.sort();
}
--fcc-editable-region--

const calculate = () => {
  const value = document.querySelector("#numbers").value;
  const array = value.split(/,\s*/g);
  const numbers = array.map(el => Number(el)).filter(el => !isNaN(el));
  
  const mean = getMean(numbers);

  document.querySelector("#mean").textContent = mean;
}
```
