---
id: 6352f179bdca23221298a5ba
title: Step 45
challengeType: 0
dashedName: step-45
---

# --description--

Your next calculation is the <dfn>range</dfn>, which is the difference between the largest and smallest numbers in the list.

You previously learned about the global `Math` object. `Math` has a `.min()` method to get the smallest number from a series of numbers, and the `.max()` method to get the largest number. Here's an example that gets the smallest number from an array:

```js
const numbersArr = [2, 3, 1];

console.log(Math.min(...numbersArr));
// Expected output: 1
```

Declare a `getRange` function that takes the same `array` parameter you have been using. Using `Math.min()`, `Math.max()`, and the spread operator, return the difference between the largest and smallest numbers in the list.

# --hints--

You should define a `getRange` function.

```js
assert.isFunction(getRange);
```

Your `getRange` function should take an `array` parameter.

```js
assert.match(getRange.toString(), /array/);
```

Your `getRange` function should use the spread operator on the `array` parameter.

```js
assert.match(code.split("getRange")[1], /\.\.\.array/);
```

Your `getRange` function should use `Math.max` on the spread `array` parameter.

```js
assert.match(code.split("getRange")[1], /Math\.max\(\s*\.\.\.array\s*\)/);
```

Your `getRange` function should use `Math.min` on the spread `array` parameter.

```js
assert.match(code.split("getRange")[1], /Math\.min\(\s*\.\.\.array\s*\)/);
```

Your `getRange` function should return the difference between the largest and smallest numbers in the list.

```js
assert.equal(getRange([1, 2, 3, 4, 5]), 4);
assert.equal(getRange([1, 2, 3, 4, 5, 6, 7, 8, 9, 10]), 9);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link rel="stylesheet" href="./styles.css" />
    <script src="./script.js"></script>
    <title>Statistics Calculator</title>
  </head>
  <body>
    <h1>Statistics Calculator</h1>
    <p>Enter a list of comma-separated numbers.</p>
    <form onsubmit="calculate(); return false;">
      <label for="numbers">Numbers:</label>
      <input type="text" name="numbers" id="numbers" />
      <button type="submit">Calculate</button>
    </form>
    <div class="results">
      <p>
        The <dfn>mean</dfn> of a list of numbers is the average, calculated by
        taking the sum of all numbers and dividing that by the count of numbers.
      </p>
      <p class="bold">Mean: <span id="mean"></span></p>
      <p>
        The <dfn>median</dfn> of a list of numbers is the number that appears in
        the middle of the list, when sorted from least to greatest.
      </p>
      <p class="bold">Median: <span id="median"></span></p>
      <p>
        The <dfn>mode</dfn> of a list of numbers is the number that appears most
        often in the list.
      </p>
      <p class="bold">Mode: <span id="mode"></span></p>
      <p>
        The <dfn>range</dfn> of a list of numbers is the difference between the
        largest and smallest numbers in the list.
      </p>
      <p class="bold">Range: <span id="range"></span></p>
      <p>
        The <dfn>variance</dfn> of a list of numbers measures how far the values
        are from the mean, on average.
      </p>
      <p class="bold">Variance: <span id="variance"></span></p>
      <p>
        The <dfn>standard deviation</dfn> of a list of numbers is the square
        root of the variance.
      </p>
      <p class="bold">
        Standard Deviation: <span id="standardDeviation"></span>
      </p>
    </div>
  </body>
</html>
```

```css
body {
  margin: 0;
  background-color: rgb(27, 27, 50);
  text-align: center;
  color: #fff;
}

button {
  cursor: pointer;
  background-color: rgb(59, 59, 79);
  border: 3px solid white;
  color: white;
}

input {
  background-color: rgb(10, 10, 35);
  color: white;
  border: 1px solid rgb(59, 59, 79);
}

.bold {
  font-weight: bold;
}
```

```js
const getMean = (array) => array.reduce((acc, el) => acc + el, 0) / array.length;

const getMedian = (array) => {
  const sorted = array.toSorted((a, b) => a - b);
  const median =
    sorted.length % 2 === 0
      ? getMean([sorted[sorted.length / 2], sorted[sorted.length / 2 - 1]])
      : sorted[Math.floor(sorted.length / 2)];
  return median;
}

const getMode = (array) => {
  const counts = {};
  array.forEach(el => counts[el] = counts[el] ? counts[el] + 1 : 1);

  if (new Set(Object.values(counts)).size === 1) {
    return null;
  }
  const highest = Object.keys(counts).sort(
    (a, b) => counts[b] - counts[a]
  )[0];
  const mode = Object.keys(counts).filter(
    (el) => counts[el] === counts[highest]
  );
  return mode.join(", ");
}

--fcc-editable-region--

--fcc-editable-region--

const calculate = () => {
  const value = document.querySelector("#numbers").value;
  const array = value.split(/,\s*/g);
  const numbers = array.map(el => Number(el)).filter(el => !isNaN(el));
  
  const mean = getMean(numbers);
  const median = getMedian(numbers);
  const mode = getMode(numbers);

  document.querySelector("#mean").textContent = mean;
  document.querySelector("#median").textContent = median;
  document.querySelector("#mode").textContent = mode;
}
```
