---
id: 5f45a276c093334f0f6e9df4
title: Step 73
challengeType: 0
dashedName: step-73
---

# --description--

Focusing on the menu items and prices, there is a fairly large gap between each line.

Use the existing selector that targets all the `p` elements nested in elements with the class named `item` and set their top and bottom margin to `5px`.

# --hints--

You should set the `margin-top` property to `5px`.

```js
const hasMarginTop = new __helpers.CSSHelp(document).getCSSRules().some(x => x.style['margin-top'] === '5px');
assert(hasMarginTop);
```

You should set the `margin-bottom` property to `5px`.

```js
const hasMarginBottom = new __helpers.CSSHelp(document).getCSSRules().some(x => x.style['margin-bottom'] === '5px');
assert(hasMarginBottom);
```

You should use the existing `.item p` selector.

```js
const hasOneSelector = new __helpers.CSSHelp(document).getStyleDeclarations('.item p');
assert(hasOneSelector.length === 1);
```

Your `p` elements nested in your `.item` elements should have a `margin-top` of `5px`.

```js
const itemPMarginTop = new __helpers.CSSHelp(document).getStyle('.item p')?.getPropertyValue('margin-top');
assert(itemPMarginTop === '5px');
```

Your `p` elements nested in your `.item` elements should have a `margin-bottom` of `5px`.

```js
const itemPMarginBottom = new __helpers.CSSHelp(document).getStyle('.item p')?.getPropertyValue('margin-bottom');
assert(itemPMarginBottom === '5px');
```

Your `p` elements nested in your `.item` elements should not have a `margin-left` set.

```js
const itemPMarginLeft = new __helpers.CSSHelp(document).getStyle('.item p')?.getPropertyValue('margin-left');
assert(!itemPMarginLeft);
```

Your `p` elements nested in your `.item` elements should not have a `margin-right` set.

```js
const itemPMarginRight = new __helpers.CSSHelp(document).getStyle('.item p')?.getPropertyValue('margin-right');
assert(!itemPMarginRight);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Cafe Menu</title>
    <link href="styles.css" rel="stylesheet"/>
  </head>
  <body>
    <div class="menu">
      <main>
        <h1>CAMPER CAFE</h1>
        <p class="established">Est. 2020</p>
        <hr>
        <section>
          <h2>Coffee</h2>
          <article class="item">
            <p class="flavor">French Vanilla</p><p class="price">3.00</p>
          </article>
          <article class="item">
            <p class="flavor">Caramel Macchiato</p><p class="price">3.75</p>
          </article>
          <article class="item">
            <p class="flavor">Pumpkin Spice</p><p class="price">3.50</p>
          </article>
          <article class="item">
            <p class="flavor">Hazelnut</p><p class="price">4.00</p>
          </article>
          <article class="item">
            <p class="flavor">Mocha</p><p class="price">4.50</p>
          </article>
        </section>
        <section>
          <h2>Desserts</h2>
          <article class="item">
            <p class="dessert">Donut</p><p class="price">1.50</p>
          </article>
          <article class="item">
            <p class="dessert">Cherry Pie</p><p class="price">2.75</p>
          </article>
          <article class="item">
            <p class="dessert">Cheesecake</p><p class="price">3.00</p>
          </article>
          <article class="item">
            <p class="dessert">Cinnamon Roll</p><p class="price">2.50</p>
          </article>
        </section>
      </main>
      <hr>
      <footer>
        <p>
          <a href="https://www.freecodecamp.org" target="_blank">Visit our website</a>
        </p>
        <p>123 Free Code Camp Drive</p>
      </footer>
    </div>
  </body>
</html>
```

```css
body {
  background-image: url(https://cdn.freecodecamp.org/curriculum/css-cafe/beans.jpg);
  font-family: sans-serif;
  padding: 20px;
}

h1 {
  font-size: 40px;
}

h2 {
  font-size: 30px;
}

.established {
  font-style: italic;
}

h1, h2, p {
  text-align: center;
}

.menu {
  width: 80%;
  background-color: burlywood;
  margin-left: auto;
  margin-right: auto;
  padding: 20px;
  max-width: 500px;
}

hr {
  height: 2px;
  background-color: brown;
  border-color: brown;
}

--fcc-editable-region--
h1, h2 {
  font-family: Impact, serif;
}

.item p {
  display: inline-block;

}

.flavor, .dessert {
  text-align: left;
  width: 75%;
}

.price {
  text-align: right;
  width: 25%;
}
--fcc-editable-region--
```

