---
id: 66325a250690a3612c1db0f6
title: Step 5
challengeType: 0
dashedName: step-5
---

# --description--

CamperBot has created a new variable called `bgHexCodeSpanElement` to store the reference to the `span` element with the `id` of `bg-hex-code`. However, when they try to log that variable to the console, they get `null`. 

`null` is a special value in JavaScript that represents the absence of a value. This can happen when you try to access a property of an object that doesn't exist. 

In this case, CamperBot is not passing in the correct selector to the `document.querySelector` method.

Fix the `document.querySelector("bg-hex-code")` line so that it correctly selects the element with the `id` of `bg-hex-code`.

# --hints--

You should fix `"bg-hex-code"` so it correctly references the `id` of `bg-hex-code`. Remember that `id` selectors in CSS start with a hash symbol (`#`).

```js
assert.match(bgHexCodeSpanElement.id, /bg-hex-code/);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Build a random background color changer</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
    <h1>Random Background Color changer</h1>

    <main>
      <section class="bg-information-container">
        <p>Hex Code: <span id="bg-hex-code">#110815</span></p>
      </section>

      <button class="btn" id="btn">Change Background Color</button>
    </main>
    <script src="./script.js"></script>
  </body>
</html>
```

```css
*,
*::before,
*::after {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

:root {
  --yellow: #f1be32;
  --golden-yellow: #feac32;
  --dark-purple: #110815;
  --light-grey: #efefef;
}

body {
  background-color: var(--dark-purple);
  color: var(--light-grey);
  text-align: center;
}

.bg-information-container {
  margin: 15px 0 25px;
  font-size: 1.2rem;
}

.btn {
  cursor: pointer;
  padding: 10px;
  margin: 10px;
  color: var(--dark-purple);
  background-color: var(--golden-yellow);
  background-image: linear-gradient(#fecc4c, #ffac33);
  border-color: var(--golden-yellow);
  border-width: 3px;
}

.btn:hover {
  background-image: linear-gradient(#ffcc4c, #f89808);
}

```

```js
const darkColorsArr = [
  "#2C3E50",
  "#34495E",
  "#2C2C2C",
  "#616A6B",
  "#4A235A",
  "#2F4F4F",
  "#0E4B5A",
  "#36454F",
  "#2C3E50",
  "#800020",
];
function getRandomIndex() {
  const randomIndex = Math.floor(darkColorsArr.length * Math.random());
  return randomIndex;
}

--fcc-editable-region--
const body = document.querySelector("body");
const bgHexCodeSpanElement = document.querySelector("bg-hex-code");

console.log(bgHexCodeSpanElement);
--fcc-editable-region--
```
