---
id: 660a8c3b21100c6b83e57cb0
title: Step 60
challengeType: 20
dashedName: step-60
---

# --description--

If the recursive call returns `False`, it means the guess led to an unsolvable sudoku. So you'll need to restore the cell to be empty and explore another guess.

After the innermost `if` statement, set the current cell value back to `0`.

# --hints--

You should set the current cell value back to `0` after the innermost `if` statement.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Board").find_function("solver").find_for_loops()[0].find_ifs()[0].find_bodies()[0].is_equivalent("row, col = next_empty\\nself.board[row][col] = guess\\nif self.solver():\\n  return True\\nself.board[row][col] = 0")`)) })
```

# --seed--

## --seed-contents--

```py
class Board:
    def __init__(self, board):
        self.board = board

    def find_empty_cell(self):
        for row, contents in enumerate(self.board):
            try:
                col = contents.index(0)
                return row, col
            except ValueError:
                pass
        return None

    def valid_in_row(self, row, num):
        return num not in self.board[row]

    def valid_in_col(self, col, num):
        return all(self.board[row][col] != num for row in range(9))

    def valid_in_square(self, row, col, num):
        row_start = (row // 3) * 3
        col_start = (col // 3) * 3
        for row_no in range(row_start, row_start + 3):
            for col_no in range(col_start, col_start + 3):
                if self.board[row_no][col_no] == num:
                    return False
        return True

    def is_valid(self, empty, num):
        row, col = empty
        valid_in_row = self.valid_in_row(row, num)
        valid_in_col = self.valid_in_col(col, num)
        valid_in_square = self.valid_in_square(row, col, num)
        return all([valid_in_row, valid_in_col, valid_in_square])
--fcc-editable-region--
    def solver(self):
        if (next_empty := self.find_empty_cell()) is None:
            return True
        for guess in range(1, 10):
            if self.is_valid(next_empty, guess):
                row, col = next_empty
                self.board[row][col] = guess
                if self.solver():
                    return True
--fcc-editable-region--
puzzle = [
  [0, 0, 2, 0, 0, 8, 0, 0, 0],
  [0, 0, 0, 0, 0, 3, 7, 6, 2],
  [4, 3, 0, 0, 0, 0, 8, 0, 0],
  [0, 5, 0, 0, 3, 0, 0, 9, 0],
  [0, 4, 0, 0, 0, 0, 0, 2, 6],
  [0, 0, 0, 4, 6, 7, 0, 0, 0],
  [0, 8, 6, 7, 0, 4, 0, 0, 0],
  [0, 0, 0, 5, 1, 9, 0, 0, 8],
  [1, 7, 0, 0, 0, 6, 0, 0, 5]
]

gameboard = Board(puzzle)
```
