---
id: 660ac35d55a15d81afdedd76
title: Step 73
challengeType: 20
dashedName: step-73
---

# --description--

Inside the `for` loop, declare a variable `row_str` and assign it a list comprehension that iterates over `row` and turns each item `i` in `row` into a string. Use the `str()` function for that.

# --hints--

You should declare a variable `row_str`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Board").find_function("__str__").find_for_loops()[0].find_bodies()[0].has_variable("row_str")`)) })
```

You should assign a list comprehension that iterates over `row` to the `row_str` variable.

```js
({ test: () => (runPython(`
import ast
var = _Node(_code).find_class("Board").find_function("__str__").find_for_loops()[0].find_bodies()[0].find_variable("row_str")
assert var.find_comp_iters()[0].is_equivalent("row"), "You should iterate over row"
assert isinstance(var.tree.value, ast.ListComp), "It's not a list comprehension"
`)) })
```

The list comprehension assigned to the `row_str` variable should use `i` as iteration variable.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Board").find_function("__str__").find_for_loops()[0].find_bodies()[0].find_variable("row_str").find_comp_targets()[0].is_equivalent("i")`)) })
```

The list comprehension assigned to the `row_str` variable should call `str()` on each item `i` in `row`.

```js
({ test: () => assert(runPython(`_Node(_code).find_class("Board").find_function("__str__").find_for_loops()[0].find_bodies()[0].find_variable("row_str").find_comp_expr().is_equivalent("str(i)")`)) })
```

# --seed--

## --seed-contents--

```py
class Board:
    def __init__(self, board):
        self.board = board
--fcc-editable-region--
    def __str__(self):
        board_str = ''
        for row in self.board:
            pass
--fcc-editable-region--
    def find_empty_cell(self):
        for row, contents in enumerate(self.board):
            try:
                col = contents.index(0)
                return row, col
            except ValueError:
                pass
        return None

    def valid_in_row(self, row, num):
        return num not in self.board[row]

    def valid_in_col(self, col, num):
        return all(self.board[row][col] != num for row in range(9))

    def valid_in_square(self, row, col, num):
        row_start = (row // 3) * 3
        col_start = (col // 3) * 3
        for row_no in range(row_start, row_start + 3):
            for col_no in range(col_start, col_start + 3):
                if self.board[row_no][col_no] == num:
                    return False
        return True

    def is_valid(self, empty, num):
        row, col = empty
        valid_in_row = self.valid_in_row(row, num)
        valid_in_col = self.valid_in_col(col, num)
        valid_in_square = self.valid_in_square(row, col, num)
        return all([valid_in_row, valid_in_col, valid_in_square])

    def solver(self):
        if (next_empty := self.find_empty_cell()) is None:
            return True
        for guess in range(1, 10):
            if self.is_valid(next_empty, guess):
                row, col = next_empty
                self.board[row][col] = guess
                if self.solver():
                    return True
                self.board[row][col] = 0
        return False

def solve_sudoku(board):
    gameboard = Board(board)
    print(f'Puzzle to solve:\n{gameboard}')
    if gameboard.solver():
        print(f'Solved puzzle:\n{gameboard}')
    else:
        print('The provided puzzle is unsolvable.')
    return gameboard

puzzle = [
  [0, 0, 2, 0, 0, 8, 0, 0, 0],
  [0, 0, 0, 0, 0, 3, 7, 6, 2],
  [4, 3, 0, 0, 0, 0, 8, 0, 0],
  [0, 5, 0, 0, 3, 0, 0, 9, 0],
  [0, 4, 0, 0, 0, 0, 0, 2, 6],
  [0, 0, 0, 4, 6, 7, 0, 0, 0],
  [0, 8, 6, 7, 0, 4, 0, 0, 0],
  [0, 0, 0, 5, 1, 9, 0, 0, 8],
  [1, 7, 0, 0, 0, 6, 0, 0, 5]
]
```
