---
id: 61695d1fbc003856628bf561
title: Step 4
challengeType: 0
dashedName: step-4
---

# --description--

The `charset` attribute specifies the character encoding used by the document. `utf-8` (Unicode Transformation Format – 8-bit) is a character encoding standard used for electronic communication.

Inside the `head` element, nest a `meta` element with the attribute `charset` set to `"utf-8"`.

# --hints--

You should have one `meta` element.

```js
const meta = document.querySelectorAll('meta');
assert.strictEqual(meta?.length, 1);
```

Your `meta` element should be a void element, it should not have a closing tag `</meta>`.

```js
assert.notMatch(code, /<\/meta>/i);
```

Your `meta` element should have a `charset` attribute set to the value `"utf-8"`.

```js
const meta = [...document.querySelectorAll('meta')];
const target = meta?.find(m => m?.getAttribute('charset')?.toLowerCase() === 'utf-8');
assert.exists(target);
```

Your `meta` element should be inside the `head` element.

```js
const metaElementRegex = /<head\s*>(?:.|\r|\n)*?<meta(?:.|\r|\n)*?<\/head\s*>/i;
assert.match(code, metaElementRegex);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
--fcc-editable-region--
  <head>
    <title>Colored Markers</title>
  </head>
--fcc-editable-region--
  <body>
  </body>
</html>
```
