---
id: 616965351e74d4689eb6de30
title: Step 5
challengeType: 0
dashedName: step-5
---

# --description--

You can have multiple `meta` elements on a web page. Each `meta` element adds information about the page that cannot be expressed by other HTML elements.

Add another `meta` element within the `head`. Give it a `name` attribute set to `"viewport"` and a `content` attribute set to `"width=device-width, initial-scale=1.0"` so your page looks the same on all devices.

# --hints--

You should have two `meta` elements.

```js
const meta = document.querySelectorAll('meta');
assert.strictEqual(meta?.length, 2);
```

Your new `meta` element should be a void element, it should not have a closing tag `</meta>`.

```js
assert.notMatch(code, /<\/meta>/i);
```


Your new `meta` element should have a `name` attribute set to `"viewport"`, and a `content` attribute set to `"width=device-width, initial-scale=1.0"`.

```js
const meta = [...document.querySelectorAll('meta')];
const contentAttrRegex = /^\s*width\s*=\s*device-width\s*,\s*initial-scale\s*=\s*1(?:\.0)?\s*$/i;
const target = meta?.find(m => m?.getAttribute('name')?.toLowerCase()?.replace(/\s*/g, '') === 'viewport' && contentAttrRegex.test(m?.getAttribute('content')));
assert.exists(target);
```

Your two `meta` elements should be inside the `head` element.

```js
const headContentRegex = /(?<=<head\s*>)[\S|\s]*(?=<\/head\s*>)/;
const headElementContent = code.match(headContentRegex);

const headElement = document.createElement("head");
headElement.innerHTML = headElementContent;
assert.strictEqual(headElement.querySelectorAll('meta').length, 2);
```

# --seed--

## --seed-contents--

```html
<!DOCTYPE html>
<html lang="en">
--fcc-editable-region--
  <head>
    <meta charset="utf-8">
    <title>Colored Markers</title>
  </head>
--fcc-editable-region--
  <body>
  </body>
</html>
```
